globals
[
  gini-index-reserve
  lorenz-points
  max-wealth
  min-wealth
  max-income
  min-income
  monthly-bi
  max-indiv-cost-of-living
]

patches-own
[
  patch-income      ;; the current amount of income on this patch
  monthly-income
]

turtles-own
[
  wealth    ;; the amount of money a turtle has
  after-tax ;; amount of income left after paying taxes
  min-indiv-cost-of-living ;; individual minimum cost of living based on minimum set on interface
]

;;;
;;; SETUP AND HELPERS
;;;

to setup
  clear-all
  ;; call other procedures to set up various parts of the world
  setup-patches
  setup-turtles
  update-lorenz-and-gini
  reset-ticks
end

;; set up the initial amounts of income each patch has
to setup-patches
  ;; set up patch income random amount between 0 and upper limit of income
  ;; set colour so richer patches have darker colour (in quintiles)
  ask patches
    [ if income-distribution = "random"
      [
        set patch-income random (mean-annual-income * 2)
      ]
      if income-distribution = "normal"
      [
        set patch-income random-normal  mean-annual-income (mean-annual-income / 2) ;; latter value is an estimate of the standard deviation based on what the curve looks like
      ]
      if income-distribution = "exponential"
      [
        set patch-income random-exponential (mean-annual-income)
      ]
      if patch-income < 0
      [
        set patch-income 0
      ]
      set max-income max [ patch-income ] of patches       ;; find highest income
      if patch-income < max-income * 1 / 5 [ set pcolor 58 ]   ;; colour patches based on income levels
      if patch-income >= max-income * 1 / 5 and patch-income < max-income * 2 / 5 [ set pcolor 57 ]
      if patch-income >= max-income * 2 / 5 and patch-income < max-income * 3 / 5 [ set pcolor 56 ]
      if patch-income >= max-income * 3 / 5 and patch-income < max-income * 4 / 5 [ set pcolor 55 ]
      if patch-income >= max-income * 4 / 5 [ set pcolor 54 ]
  ]
end

;; set up the initial values for the turtle variables
to setup-turtles
  set-default-shape turtles "person"
  create-turtles num-people
  ask turtles [
    move-to one-of patches with [not any? turtles-here]
    ifelse allow-varied-min-cost-of-living [
    set min-indiv-cost-of-living random-normal min-monthly-cost-of-living (min-monthly-cost-of-living / 6)
      set max-indiv-cost-of-living max [min-indiv-cost-of-living] of turtles ]
    [set min-indiv-cost-of-living min-monthly-cost-of-living]
    if inheritance-distribution = "random"     ;; wealth
    [
      set wealth random (mean-inheritance * 2)
    ]
    if inheritance-distribution = "normal"
    [
      set wealth random-normal mean-inheritance (mean-inheritance / 4) ;; latter value is an estimate of the standard deviation
    ]
    if inheritance-distribution = "exponential"
    [
      set wealth random-exponential (mean-inheritance)
    ]
    if wealth <= 0
    [
      set wealth 1
    ]
    color-turtles
    if inheritance-tax = "flat"                     ;; wealth tax happens once at beginning (if it happens at all)
    [ set wealth wealth * ( 1 - max-tax-rate / 100 ) ]
    if inheritance-tax = "progressive"
    [ if color = 1 [ set wealth wealth * (1 - max-tax-rate / 100) ]
      if color = 2 [ set wealth wealth * (1 - 0.8 * max-tax-rate / 100) ]
      if color = 3 [ set wealth wealth * (1 - 0.6 * max-tax-rate / 100) ]
      if color = 4 [ set wealth wealth * (1 - 0.4 * max-tax-rate / 100) ]
      if color = 5 [ set wealth wealth * (1 - 0.2 * max-tax-rate / 100) ]
    ]
    set monthly-income patch-income / 12
    face one-of neighbors4
  ]
end

;;;
;;; GO AND HELPERS
;;;

to go
  ask turtles
  [
    upgrade-income   ;; move to neighbouring patch if it has more income
    update-wealth    ;; add net income to wealth
    color-turtles    ;; set colour according to wealth quintile
  ]
  update-lorenz-and-gini
  set min-income min [ patch-income ] of patches
  set min-wealth min [ wealth ] of turtles
  tick
end

to go-ten-years
  ask turtles
  [
    upgrade-income   ;; move to neighbouring patch if it has more income
    update-wealth    ;; add net income to wealth
    color-turtles    ;; set colour according to wealth quintile
  ]
  update-lorenz-and-gini
  tick
  if ticks = 120
  [
    reset-ticks
    stop
  ]
end


;; determine the direction which is most profitable for each turtle in
;; the surrounding patches within one patch
;; the only way I could get this to work was to have them just check one direction per tick

to upgrade-income  ;; turtle procedure
  let patch-income-ahead patch-income-at-angle 0
  ;; if patch ahead has a higher income, go to it; and either way, rotate right 90°
  if (patch-income-ahead > patch-income)
  [ if not any? other turtles-on patch-ahead 1
    [ forward 1 ]]
  rt 90
  set monthly-income patch-income / 12
end

;; check out which neighbouring patch has the highest income (cribbed from ants)
to-report patch-income-at-angle [angle]
  let p patch-right-and-ahead angle 1
  report [patch-income] of p
end

;; add monthly income to wealth and subtract cost of living; grade cost of living to income if high enough

to update-wealth
  ;; set income tax rate: after-tax = proportion of income left after paying taxes
  if income-tax = "none" [ set after-tax 1 ]
  if income-tax = "flat" [ set after-tax 1 - max-tax-rate / 100 ]
  if income-tax = "progressive with loopholes for rich"
  [ if pcolor = 54 [ set after-tax 1 - 0.6 * (max-tax-rate / 100) ]
    if pcolor = 55 [ set after-tax 1 - 0.8 * (max-tax-rate / 100) ]
    if pcolor = 56 [ set after-tax 1 - 0.6 * (max-tax-rate / 100) ]
    if pcolor = 57 [ set after-tax 1 - 0.4 * (max-tax-rate / 100) ]
    if pcolor = 58 [ set after-tax 1 - 0.2 * (max-tax-rate / 100) ]
  ]
  if income-tax = "progressive no loopholes for rich"
  [ if pcolor = 54 [ set after-tax 1 - 1.0 * (max-tax-rate / 100) ]
    if pcolor = 55 [ set after-tax 1 - 0.8 * (max-tax-rate / 100) ]
    if pcolor = 56 [ set after-tax 1 - 0.6 * (max-tax-rate / 100) ]
    if pcolor = 57 [ set after-tax 1 - 0.4 * (max-tax-rate / 100) ]
    if pcolor = 58 [ set after-tax 1 - 0.2 * (max-tax-rate / 100) ]
  ]
  ;; set redistribution
  if income-redistribution = "none"
  [
    set monthly-bi 0
  ]
  if income-redistribution = "universal demogrant"   ;; give everyone the same top-up
  [
    set monthly-bi max-bi / 12
  ]
  if income-redistribution = "NIT with clawback"   ;; calculate partial BI after clawback
  [
    set monthly-bi max-bi / 12
    ifelse (monthly-income * after-tax * (clawback / 100)) < monthly-bi   ;; is after tax income too high with clawback?, if not proceed
    [
      set monthly-bi monthly-bi - (monthly-income * after-tax * (clawback / 100))
    ]
    ;; for NIT, if after-tax income is too high, don't give a BI
    [
      set monthly-bi 0
    ]
  ]
  ;; calculate new wealth
  ifelse ((monthly-bi + (monthly-income * after-tax)) * 3 / 4) < min-indiv-cost-of-living ;; deduct cost of living
  [set wealth wealth + monthly-bi + (monthly-income * after-tax) - min-indiv-cost-of-living ]
  [set wealth wealth + monthly-bi + (monthly-income * after-tax / 4) ]
end

to color-turtles
  set max-wealth  max [ wealth ] of turtles
    if wealth < max-wealth / 5
    [ set color 5 ]
    if (wealth >= max-wealth / 5 and wealth < max-wealth * 2 / 5)
    [ set color 4 ]
    if (wealth >= max-wealth * 2 / 5 and wealth < max-wealth * 3 / 5)
    [ set color 3 ]
    if (wealth >= max-wealth * 3 / 5 and wealth < max-wealth * 4 / 5)
    [ set color 2 ]
    if (wealth >= max-wealth * 4 / 5)
    [ set color 1 ]
    if wealth <= 0
    [ set wealth 1
      set color red
    ]
end

;; this procedure recomputes the value of gini-index-reserve
;; and the points in lorenz-points for the Lorenz and Gini-Index plots
to update-lorenz-and-gini
    let sorted-wealths sort [wealth] of turtles
  let total-wealth sum sorted-wealths
  let wealth-sum-so-far 0
  let index 0
  set gini-index-reserve 0
  set lorenz-points []

  ;; now actually plot the Lorenz curve -- along the way, we also
  ;; calculate the Gini index.
  ;; (see the Info tab for a description of the curve and measure)
  repeat count turtles [
    set wealth-sum-so-far (wealth-sum-so-far + item index sorted-wealths)
    set lorenz-points lput ((wealth-sum-so-far / total-wealth) * 100) lorenz-points
    set index (index + 1)
    set gini-index-reserve
      gini-index-reserve +
      (index / num-people) -
      (wealth-sum-so-far / total-wealth)
  ]
end


; Copyright 1998 Uri Wilensky and 2018 Sarah Robertson
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
481
10
935
465
-1
-1
21.24
1
10
1
1
1
0
1
1
1
-10
10
-10
10
1
1
1
ticks
30.0

SLIDER
13
137
236
170
mean-annual-income
mean-annual-income
0
100000
46000.0
1000
1
$
HORIZONTAL

BUTTON
14
50
80
83
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
91
51
172
84
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
14
10
186
43
num-people
num-people
0
440
427.0
1
1
NIL
HORIZONTAL

SLIDER
252
138
450
171
mean-inheritance
mean-inheritance
100
1000000
46000.0
1000
1
$
HORIZONTAL

BUTTON
249
52
427
85
Go ten years (120 ticks)
go-ten-years
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
13
176
235
209
min-monthly-cost-of-living
min-monthly-cost-of-living
0
8000
1500.0
100
1
$
HORIZONTAL

BUTTON
179
51
242
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
268
292
468
412
gini vs time
time
gini
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot (gini-index-reserve / num-people) / 0.5"

CHOOSER
11
323
188
368
income-redistribution
income-redistribution
"none" "NIT with clawback" "universal demogrant"
0

MONITOR
268
418
376
463
gini coefficient
(gini-index-reserve / num-people) / 0.5
2
1
11

PLOT
947
10
1166
130
wealth distribution
Quintile
Count
0.0
6.0
0.0
10.0
true
false
"set-plot-y-range 0 num-people\n" ""
PENS
"default" 1.0 1 -16777216 true "" "plot-pen-reset\nset-plot-pen-color red\nplot count turtles with [color = red]\nset-plot-pen-color 5\nplot count turtles with [color = 5]\nset-plot-pen-color 4\nplot count turtles with [color = 4]\nset-plot-pen-color 3\nplot count turtles with [color = 3]\nset-plot-pen-color 2\nplot count turtles with [color = 2]\nset-plot-pen-color 1\nplot count turtles with [color = 1]"

CHOOSER
12
269
150
314
inheritance-tax
inheritance-tax
"none" "flat" "progressive"
2

SLIDER
11
413
144
446
clawback
clawback
0
100
50.0
1
1
%
HORIZONTAL

MONITOR
400
419
467
464
% in debt
100 * count turtles with [ color = red ] / num-people
2
1
11

SLIDER
260
230
432
263
max-tax-rate
max-tax-rate
0
100
50.0
1
1
%
HORIZONTAL

SLIDER
11
374
183
407
max-bi
max-bi
0
100000
18000.0
100
1
$
HORIZONTAL

PLOT
947
135
1167
255
income distribution
Quintile
Count
0.0
5.0
0.0
10.0
true
false
"\n" ""
PENS
"default" 1.0 1 -16777216 true "" "plot-pen-reset\nset-plot-pen-color 58\nplot count patches with [pcolor = 58]\nset-plot-pen-color 57\nplot count patches with [pcolor = 57]\nset-plot-pen-color 56\nplot count patches with [pcolor = 56]\nset-plot-pen-color 55\nplot count patches with [pcolor = 55]\nset-plot-pen-color 54\nplot count patches with [pcolor = 54]"

CHOOSER
13
88
162
133
income-distribution
income-distribution
"random" "normal" "exponential"
1

CHOOSER
252
88
425
133
inheritance-distribution
inheritance-distribution
"random" "normal" "exponential"
2

CHOOSER
12
217
253
262
income-tax
income-tax
"none" "flat" "progressive with loopholes for rich" "progressive no loopholes for rich"
0

PLOT
948
262
1167
382
min. cost of living distribution
Quintile
Count
0.0
5.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "plot-pen-reset\nplot count turtles with [min-indiv-cost-of-living < max-indiv-cost-of-living / 5]\nplot count turtles with [min-indiv-cost-of-living >= max-indiv-cost-of-living / 5 and min-indiv-cost-of-living < max-indiv-cost-of-living * 2 / 5]\nplot count turtles with [min-indiv-cost-of-living >= max-indiv-cost-of-living * 2 / 5 and min-indiv-cost-of-living < max-indiv-cost-of-living * 3 / 5]\nplot count turtles with [min-indiv-cost-of-living >= max-indiv-cost-of-living * 3 / 5 and min-indiv-cost-of-living < max-indiv-cost-of-living * 4 / 5]\nplot count turtles with [min-indiv-cost-of-living >= max-indiv-cost-of-living * 4 / 5]"

SWITCH
252
178
475
211
allow-varied-min-cost-of-living
allow-varied-min-cost-of-living
1
1
-1000

@#$#@#$#@
## WHAT IS IT?

This model (and two related ones) are an attempt to see to what extent a basic income (BI), or other form of redistribution, and various forms of taxation have on the gini coefficient, which measures inequality (the higher the coefficient, the greater the economic inequality).

I wanted a way of testing various policies (e.g. taxing inheritances) to see if they made any difference to the gini coefficient relative to other policies. You can see the experiments I ran in BehaviorSpace (Tools -> BehaviorSpace). (What I found was that whether an inheritance tax makes any difference depends on the relative size of the average inheritance vs the average income.) These models were inspired by disagreements I had with others at NABIG (North American Basic Income Guarantee) Congress 2018. I don't think they're going to resolve any disagreements, though.

The model was designed for a ten-year period, with each step being one month, and ten years being 120 steps, but of course it can be run for shorter or longer periods as desired.

The gini coefficient is not going to be directly comparable to the gini coefficient in real life, since real-life economies are much more complex.

This version is simplified to look only at fully employable individuals of working age, not families or households, and with no seniors or disabled people. I have other models that look at those.

## HOW IT WORKS

Each agent is an individual, born with a set amount of wealth (randomly assigned based on parameters you choose). If the randomly assigned amount of wealth is negative, it is set to 1. This is the person's inheritance. Agent colour is set at the beginning in quintiles from grey to black based on their initial wealth (black being the wealthiest quintile), after any inheritance tax that you set has been deducted.

Each patch has a random amount of income (employment income, investment income, etc.). If a randomly assigned income level is negative, it is set to 0. The patches are shaded green in quintiles, with the highest income quintile having the darkest shade of green. This is done once during setup since patch income does not change. 

Each agent is randomly assigned to its own patch. On each step, the agent looks at the patch ahead, and moves to it if it is empty and its income is higher than the current patch. Then each agent rotates right 90° so that it faces a new direction on each step.

From there, each agent earns the monthly income for its patch, deducts its cost of living, and adds the rest to its total wealth. If the wealth drops below 0, the agent turns red and the wealth is reset to 1 so that the gini coefficient calculation works. For agents not in the red, agent colour is reset on every tick so that each wealth quintile has its own shade of grey, with the highest quintile being black.

The assumption is that most agents have enough income to live on (though some won't) and that they are not that mobile when it comes to work - if they see a better opening nearby they grab it but are otherwise stuck where they are. They are not perfectly capable of finding the highest paying patch nearby, but they do their best.

Note that the agents *are* perfectly rational when it comes to savings, and if they can afford it, never spend more than 75% of their income on living expenses. Obviously this is not the real world.

If there is an inheritance tax it is applied during setup. Income taxes are paid monthly along with income (one step = one month).

There is no inflation, increase in cost of living, or increase in income in the model. Nobody dies.

The gini coefficient is recalculated on each step.

## HOW TO USE IT

Choose the number of individuals. This could be based on the job vacancy rate, so that the number of empty patches roughly represents the number of jobs available at any one time.

Choose the average (mean, not median) annual income (which will be divided by 12 for monthly income) and inheritance, and choose how you want these to be distributed among the population (randomly, normally, or exponentially). You can base this on real life statistics for a given country if you like, or just make something up. If you are running the model for a ten year period you should probably adjust the mean inheritance to take into account that it is only inheritances for a shorter period, rather than a lifetime. (I divided my estimated mean inheritance/wealth by about 5 to take this into account.)

Choose the lowest monthly cost of living, and whether you want it to be exactly the same for each agent or distributed normally around a mean, using the allow-varied-indiv-min-cost-of-living chooser. (My experience is it doesn't make any difference to the gini coefficient, but I wanted to try it to see, so I included it and kept it in.) The cost of living will be this value, or 75% of the after-tax income, whichever is greater.

Choose what if any taxation you want to impose on agents each month, and the rate for the highest tax bracket. There are five tax brackets for progressive and semi-progressive tax rates, and they are set in the code tab.

Choose what if any income redistribution you want to give to agents each year, and set the annual amount with the max-bi slider. 

An NIT is a negative income tax, which gives a tax-free basic income to anyone below a certain threshold. The threshold is based on the amount of BI and the after-tax income multiplied by the clawback - if the after-clawback after-tax income is higher than the BI, the agent gets nothing. If the after-clawback after-tax income is less than the BI, the agent gets the BI plus the difference. For example, if you set the annual BI to 18,000 and have a clawback of 2/3, an annual after-tax income of 27,000 or more will not qualify someone for an NIT top-up (18,000 - (27,000 * 2/3) = 0), but an annual after-tax income of 15,000 will qualify the individual for an additional 8,000 per year (18,000 - (15,000 * 2/3)), and an after-tax income of 24,000 will qualify the individual for an additional 2,000 per year (18,000 - (24,000 * 2/3)).

A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            