;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@;
;@@@@ MAS HUNTING ALGORITHM PERFORMANCE EVALUATION ENVIRONMENT @@@@;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@;
;@@@@                                                          @@@@;
;@@@@  Copyright 2017 Marc Prince.                             @@@@;
;@@@@  See Info tab for full copyright and license.            @@@@;
;@@@@                                                          @@@@;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@;

; CODE FOR TROUBLESHOOTING
; show [(word "("pxcor ", " pycor")")] of self


extensions [rnd]

globals [ ; These are detailed in the World Agent (WA) Beliefs, Desires, and Intentions.
  WA_Belief_Food-Density             WA_Belief_Vegetation-Density        WA_Belief_Rock-Density              WA_Belief_Water-Density      WA_Belief_Open-Terrain
  WA_Belief_Marsh-Density            WA_Belief_Wind-Direction            WA_Belief_Wind-Strength             WA_Belief_Rain-Frequency
  WA_Belief_Rain-Intensity           WA_Belief_Prey-Adult_Number
  WA_Belief_HA-Alpha_Quantity        WA_Belief_HA-Beta_Quantity          WA_Belief_HA-Omega_Quantity         WA_Belief_HA-Type            WA_Belief_HA-Algorithm_Test
  WA_State_Sounds-Current_Cycle      WA_State_Sounds-Previous_Cycle
  WA_State_Agents-List
  WA_State_Patches-List
]

patches-own [ ; These are detailed in the World Agent under Patch Agent
  WA_Patch_State_Type                WA_Patch_State_Grow-Time
  WA_Patch_State_Colour              WA_Patch_State_Colour-Temp
  WA_Patch_State_Agent-Number        WA_Patch_State_Agent-Heading        WA_Patch_State_Agent-Speed
  WA_Patch_State_Scent-Type          WA_Patch_State_Scent-Level
  WA_Patch_State_Sounds
]

turtles-own [ ; These are detailed in the Generic Agent (GA) Beliefs, Desire, and Intentions.
  GA_State_Agent-Type     GA_State_Agent-Class      GA_State_Exhaustion          GA_State_Scan-Distance
  GA_State_Scent-Type     GA_State_Scent-Level      GA_State_Energy-Current      GA_State_Speed-Current      GA_State_Water-Current      GA_State_Voice-Level
  GA_Design_Speed-Max     GA_Design_Energy-Max      GA_Design_Hearing-Level-Min  GA_Design_Vocal-Level-Max   GA_Design_Scent-Level-Min   GA_Design_Vision-Max
  GA_Belief_Hunger-Level  GA_Belief_Water-Level     GA_Belief_Water-Bearing      GA_Belief_Patch-Colour      GA_Belief_Patch-Type
  GA_Belief_Water         GA_Belief_Water-Heading   GA_Belief_Water-Distance     GA_Belief_Water-Sources     GA_Belief_Water-atSource
  GA_Desire_Food          GA_Desire_Water           GA_Desire_Evade
  GA_Perceive_Visual-Scan
]

breed [ hunted prey ]
hunted-own [ ; These are detailed in the Prey Agent (PA) Beliefs, Desire, and Intentions.
  PA_Belief_Food          PA_Belief_Food-Heading    PA_Belief_Food-Distance    PA_Belief_Food-Sources    PA_Belief_Food-atSource
  PA_Belief_Hunter        PA_Belief_Hunter-Heading  PA_Belief_Hunter-Distance  PA_Belief_Hunter-Sees-Me  PA_Belief_Hunter-atSource
  PA_Desire_Heading-Next  PA_Desire_Hunger-Thirst
]

breed [ hunters hunter ]
hunters-own [ ; These are detailed in the Hunter Agent (HA) Beliefs, Desire, and Intentions.
  HA_State_Hunter-Type            HA_State_Hunter-Class           HA_State_Hunter-Level             HA_Belief_Hunter-Leader
  HA_Belief_Hunt-Mode
  HA_Belief_Prey-Seen             HA_Belief_Prey-Known            HA_Belief_Hunter-Prey_Heading     HA_Belief_Hunter-Prey_Distance
  HA_Belief_Prey-X                HA_Belief_Prey-Y                HA_Belief_Prey-Heading            HA_Belief_Prey-Speed
  HA_Belief_Prey-atSource         HA_Belief_Prey-Sources
  HA_Belief_Alpha                 HA_Belief_Alpha-Seen            HA_Belief_Alpha-Known             HA_Belief_Hunter-Alpha_Heading    HA_Belief_Hunter-Alpha_Distance
  HA_Belief_Alpha-X               HA_Belief_Alpha-Y               HA_Belief_Alpha-Heading           HA_Belief_Alpha-Speed
  HA_Belief_Alpha-Prey_Distance   HA_Belief_Alpha-Prey_Heading    HA_Belief_Alpha-Prey_Attack
  HA_Belief_Beta1                HA_Belief_Beta1-Seen             HA_Belief_Beta1-Known             HA_Belief_Hunter-Beta1_Heading    HA_Belief_Hunter-Beta1_Distance
  HA_Belief_Beta1-X               HA_Belief_Beta1-Y               HA_Belief_Beta1-Heading
  HA_Belief_Beta1-Prey_Distance   HA_Belief_Beta1-Prey_Heading    HA_Belief_Beta1-Encircle-X        HA_Belief_Beta1-Encircle-Y
  HA_Belief_Beta2                 HA_Belief_Beta2-Seen            HA_Belief_Beta2-Known             HA_Belief_Hunter-Beta2_Heading    HA_Belief_Hunter-Beta2_Distance
  HA_Belief_Beta2-X               HA_Belief_Beta2-Y               HA_Belief_Beta2-Heading
  HA_Belief_Beta2-Prey_Distance   HA_Belief_Beta2-Prey_Heading    HA_Belief_Beta2-Encircle-X        HA_Belief_Beta2-Encircle-Y
  HA_Belief_Omega1                HA_Belief_Omega1-Seen           HA_Belief_Omega1-Known
  HA_Belief_Omega2                HA_Belief_Omega2-Seen           HA_Belief_Omega2-Known
  HA_Belief_Heard-Call            HA_Belief_Heard-Alpha
  HA_Belief_Encircle-X            HA_Belief_Encircle-Y
  HA_Perceive-Sounds              HA_Perceive-Scents
]

links-own [_range]

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;----------------------;;
;;;;; World Agent ;;;;;;;;
;;----------------------;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;; Actions ;;;;;;;;;;;;;;
; Nomenclature: Primary - WA_action_subject_verb or Alternate - WA_action_verb_subject

to WA_action_clear-all ; clear the hunting environment
  clear-all
  reset-ticks
end

to WA_action_clear-ticks ; reset the tick count
  reset-ticks
end

to WA_action_hunters-die ; clear the hunters from the hunting environment
  ask hunters [die]
end

to WA_action_hunters-setup ; setup the HAs according to the parameters at the interface

  if WA_Belief_HA-Type = "Lionesses" [
    HA_belief_instantiate-lioness_alpha
    HA_belief_instantiate-lioness_beta
  ]

  if WA_Belief_HA-Type = "Wolves" [
    let i WA_Belief_HA-Alpha_Quantity
    while [ WA_Belief_HA-Alpha_Quantity != 0 ] [
      HA_belief_instantiate-wolf_alpha
      set WA_Belief_HA-Alpha_Quantity (WA_Belief_HA-Alpha_Quantity - 1)
    ]
    set WA_Belief_HA-Alpha_Quantity i

    set i WA_Belief_HA-Beta_Quantity
    while [ WA_Belief_HA-Beta_Quantity != 0 ] [
      HA_belief_instantiate-wolf_beta
      set WA_Belief_HA-Beta_Quantity (WA_Belief_HA-Beta_Quantity - 1)
    ]
    set WA_Belief_HA-Beta_Quantity i

    set i WA_Belief_HA-Omega_Quantity
    while [ WA_Belief_HA-Omega_Quantity != 0 ] [
      HA_belief_instantiate-wolf_omega
      set WA_Belief_HA-Omega_Quantity (WA_Belief_HA-Omega_Quantity - 1)
    ]
    set WA_Belief_HA-Omega_Quantity i
  ]

end

to WA_action_prey-die ; clear the prey from the hunting environment
  ask hunted [die]
end

to WA_action_prey-setup ; set up the prey based on the interface parameters
  let i 0
  while [ (i < WA_Belief_Prey-Adult_Number) ] [
    PA_belief_instantiate-hunted_prey_adult
    set i i + 1
  ]
end

to WA_action_setup-axes ; establish the axis on the window to the WA
  ;; draw x-axis & y-axis as light gray
  ask patches with [pxcor = 0 or pycor = 0]
    [ set pcolor gray - 3 ]
end

to WA_action_setup-food ; sets up the probability distribution on the food sources within the WA
  let random-value random 100
  let x-value min-pxcor
  let y-value min-pycor

  while [ (x-value <= max-pxcor) ] [
    set y-value min-pycor
    while [ (y-value <= max-pycor)] [
      set random-value random 100
      if random-value <= WA_Belief_Food-Density [
        ask patches with [ pxcor = x-value and pycor = y-value] [set pcolor orange]
      ]
      set y-value (y-value + 5)
    ]
    set x-value  (x-value + 5)
  ]
end

to WA_action_setup-marsh ; sets up the probability distribution on the marsh sources within the WA
  let random-value random 100
  let x-value 0
  let y-value 0
  ask patches with [ pcolor = blue ] [
    set random-value random 100
    if random-value <= WA_Belief_Marsh-Density [
      set x-value pxcor
      set y-value pycor
      if random-value < 51
        [ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor 42]]
      if (33 < random-value) and (random-value < 67)
        [ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor 42]]
      if random-value > 66 [
        ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor 42]
        ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor 42]
        ]
    ]
  ]
  ask patches with [ pcolor = sky ] [
    set random-value random 100
    if random-value <= WA_Belief_Marsh-Density [
      set x-value pxcor
      set y-value pycor
      if random-value < 34 [
        ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor 42]
      ]
      if (33 < random-value) and (random-value < 67) [
        ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor 42]
        ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor 42]
      ]
      if random-value > 66 [
        ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor 42]
        ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor 42]
        ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor 42]
        ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor 42]
      ]
    ]
  ]
end

to WA_action_setup-river ; establishes the river within the WA
;  let random-value random 100
;  let x-value min-pxcor
;  let y-value 0
  ask patches [
    if pycor = 0 [set pcolor blue     set WA_Patch_State_Type "Stream"     set WA_Patch_State_Colour blue ]
  ]

;  while [ x-value <= max-pxcor] [
;    ask patch x-value y-value [set pcolor blue]
;    ask patch x-value (y-value - 1) [set pcolor blue]
;
;    set x-value  (x-value + 1)
;    set random-value random 100
;    ifelse random-value < 51
;      [ set y-value (y-value - 1) ]
;      [ set y-value (y-value + 1) ]
;  ]
end

to WA_action_setup-statistical_features ; sets up the probability distribution of several terrain features within the WA
  let m []
  let feature_probability (list m)
  set feature_probability but-first feature_probability

  set m lput orange m
  set m lput WA_Belief_Food-Density m
  set feature_probability lput m feature_probability
  set m []

  set m lput green m
  set m lput WA_Belief_Vegetation-Density m
  set feature_probability lput m feature_probability
  set m []

  set m lput grey m
  set m lput WA_Belief_Rock-Density m
  set feature_probability lput m feature_probability
  set m []

  set m lput sky m
  set m lput WA_Belief_Water-Density m
  set feature_probability lput m feature_probability
  set m []

  set WA_Belief_Open-Terrain (100 - WA_Belief_Food-Density - WA_Belief_Vegetation-Density - WA_Belief_Rock-Density - WA_Belief_Water-Density)
  set m lput black m
  set m lput WA_Belief_Open-Terrain m
  set feature_probability lput m feature_probability
  set m []

  ask patches [
    set pcolor first rnd:weighted-one-of-list feature_probability [ [p] -> last p]
    WA_Patch_brf_instantiate
  ]
end

to WA_action_setup-rock_features ; sets up the probability distribution on the rock features within the WA
  let random-value random 100
  let x-value min-pxcor
  let y-value min-pycor

  while [ (x-value <= max-pxcor) ] [
    set y-value min-pycor
    while [ (y-value <= max-pycor)] [
      set random-value random 100
      if random-value <= WA_Belief_Rock-Density [
        set random-value random 100
        ask patches with [ pxcor = x-value and pycor = y-value] [set pcolor grey]
        if (0 < random-value) and (random-value < 26) [
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor grey]
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor grey]
        ]
        if (25 < random-value) and (random-value < 51) [
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor grey]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor grey]
        ]
        if (50 < random-value) and (random-value < 76) [
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor grey]
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor grey]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor grey]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor grey]
        ]
        if (75 < random-value) and (random-value < 101) [
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor grey]
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor grey]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor grey]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor grey]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value - 1] [set pcolor grey]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value - 1] [set pcolor grey]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value + 1] [set pcolor grey]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value + 1] [set pcolor grey]
        ]
      ]
      set y-value (y-value + 4)
    ]
    set x-value  (x-value + 4)
  ]
end

to WA_action_setup-vegetation ; sets up the probability distribution on the vegetation features within the WA
  let random-value random 100
  let x-value min-pxcor
  let y-value min-pycor

  while [ (x-value <= max-pxcor) ] [
    set y-value min-pycor
    while [ (y-value <= max-pycor)] [
      set random-value random 100
      if random-value <= WA_Belief_Vegetation-Density [
        ask patches with [ pxcor = x-value and pycor = y-value] [set pcolor green]
        set random-value random 100
        if (19 < random-value) and (random-value < 36) [
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor green]
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor green]
        ]
        if (35 < random-value) and (random-value < 51) [
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor green]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor green]
        ]
        if (50 < random-value) and (random-value < 76) [
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor green]
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor green]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor green]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor green]
        ]
        if (75 < random-value) and (random-value < 101) [
          ask patches with [ pxcor = x-value and pycor = (y-value - 1)] [set pcolor green]
          ask patches with [ pxcor = x-value and pycor = (y-value + 1)] [set pcolor green]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value] [set pcolor green]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value] [set pcolor green]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value - 1] [set pcolor green]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value - 1] [set pcolor green]
          ask patches with [ pxcor = (x-value - 1) and pycor = y-value + 1] [set pcolor green]
          ask patches with [ pxcor = (x-value + 1) and pycor = y-value + 1] [set pcolor green]
        ]
      ]
      set y-value (y-value + 5)
    ]
    set x-value  (x-value + 5)
  ]
end

to WA_action_setup-water ; sets up the probability distribution on the water sources within the WA
  let random-value random 100
  let x-value min-pxcor
  let y-value min-pycor

  while [ (x-value <= max-pxcor) ] [
    set y-value min-pycor
    while [ (y-value <= max-pycor)] [
      set random-value random 100
      if random-value <= WA_Belief_Water-Density [
        ask patches with [ pxcor = x-value and pycor = y-value] [set pcolor sky]
      ]
      set y-value (y-value + 3)
    ]
    set x-value  (x-value + 3)
  ]
end

to-report WA_action_tickCount ; counts the ticks of each deliberation cycle within the WA.
  report ticks
end

;;;;;;;;;;;;; Belief Review Function (BRF) ;;;;;;;;;;;;;;;;

;--Beliefs--;

;  WA_Belief_Setup-State                Belief: True/False - If true then the World Agent has been reset. Not Used Because No Tick to Associate Cycle...Look to Delete.
;  WA_Belief_Food-Density               Belief: The World Agent's density of food sources (apple trees, etc).
;  WA_Belief_Vegetation-Density         Belief: The World Agent's density of vegetation.
;  WA_Belief_Rock-Density               Belief: The World Agent's density of rock features.
;  WA_Belief_Water-Density              Belief: The World Agent's density of water (ponds, lakes, etc).
;  WA_Belief_Marsh-Density              Belief: The World Agent's density of marshland.
;  WA_Belief_Open-Terrain               Belief: The World Agent's density of open terrain. This value is calculated and is approximate.
;  WA_Belief_Wind-Direction             Belief: The direction of the wind.
;  WA_Belief_Wind-Strength              Belief: The strength of the wind.
;  WA_Belief_Rain-Frequency             Belief: The frequency of rain.
;  WA_Belief_Rain-Intensity             Belief: The intensity of rain.
;  WA_Belief_Prey-Adult_Number          Belief: Number of Prey.
;  WA_Belief_Hunters-Alpha_Number       Belief: Number of Alpha Hunters.
;  WA_Belief_Hunters-Beta_Number        Belief: Number of Beta Hunters.
;  WA_Belief_Hunters-Omega_Number       Belief: Number of Omega Hunters.
;  WA_State_Sounds                      State: List that holds the sounds that are in the environment during that cycle.
;  WA_Belief_HA-Type                    Belief: The type of hunters.

;--BRF--;
; Nomenclature: WA_perceive_subject_verb

to WA_brf_hunters-instantiate; This is designed as a driving function and is utilized for testing
  set WA_Belief_HA-Alpha_Quantity #Level1Hunters
  WA_action_hunters-setup
end

to WA_brf_hunters-die; This is designed as a driving function and is utilized for testing
  WA_action_hunters-die
end

to WA_brf_prey-instantiate; This is designed as a driving function and is utilized for testing
  set WA_Belief_Prey-Adult_Number Prey-Adult
  WA_action_prey-setup
end

to WA_brf_prey-die; This is designed as a driving function and is utilized for testing
  WA_action_prey-die
end

to WA_brf_setup ; Used to instantiate the WA
  set WA_Belief_Food-Density Food-Density
  set WA_Belief_Vegetation-Density Vegetation-Density
  set WA_Belief_Rock-Density Rock-Density
  set WA_Belief_Water-Density Water-Density
  set WA_Belief_Marsh-Density Marsh-Density

  set WA_Belief_Wind-Direction Wind-Direction
  set WA_Belief_Wind-Strength Wind-Strength

  set WA_Belief_Prey-Adult_Number Prey-Adult
  set WA_Belief_HA-Type Hunter-Type
  set WA_Belief_HA-Alpha_Quantity #Level1Hunters
  set WA_Belief_HA-Beta_Quantity #Level2Hunters
  set WA_Belief_HA-Omega_Quantity #Level3Hunters
  set WA_Belief_HA-Algorithm_Test Algorithm-Test

  WA_brf_sounds-initialize

end

to WA_brf_setup-food; This is designed as a driving function and is utilized for testing
  set WA_Belief_Food-Density Food-Density
  WA_action_setup-food
end

to WA_brf_setup-vegetation; This is designed as a driving function and is utilized for testing
  set WA_Belief_Vegetation-Density Vegetation-Density
  WA_action_setup-vegetation
end

to WA_brf_setup-rock_features; This is designed as a driving function and is utilized for testing
  set WA_Belief_Rock-Density Rock-Density
  WA_action_setup-rock_features
end

to WA_brf_setup-water; This is designed as a driving function and is utilized for testing
  set WA_Belief_Water-Density Water-Density
  WA_action_setup-water
end

to WA_brf_setup-river; This is designed as a driving function and is utilized for testing
  WA_action_setup-river
end

to WA_brf_setup-marsh; This is designed as a driving function and is utilized for testing
  set WA_Belief_Marsh-Density Marsh-Density
  WA_action_setup-marsh
end

to WA_brf_sounds-initialize ; Instantiates the tracking of sounds within the WA
  WA_brf_sounds-current-initialize
  WA_brf_sounds-previous-initialize
end

to WA_brf_sounds-current-initialize ; Tracks the sounds generated during this deliberation cycle (ie. current tick)
   set WA_State_Sounds-Current_Cycle []

  let m []
  set m lput 0 m                     ; sender's agent number
  set m lput "name-curr-init" m      ; sender's label
  set m lput 0 m                     ; xcor of sender
  set m lput 0 m                     ; ycor of sender
  set m lput 0 m                     ; sound-level of sender  ********this does not seem to be updating
  set m lput "Curr-Initialize" m          ; sender's message

  set WA_State_Sounds-Current_Cycle lput m WA_State_Sounds-Current_Cycle
;  show "sounds-current-initialize"
end

to WA_brf_sounds-previous-initialize ; Tracks the sounds generated during the previous deliberation cycle (ie. last tick)

  set WA_State_Sounds-Previous_Cycle []

  let m []
  set m lput 0 m                    ; sender's agent number
  set m lput "name-prev-init" m     ; sender's label
  set m lput 0 m                    ; xcor of sender
  set m lput 0 m                    ; ycor of sender
  set m lput 0 m                    ; sound-level of sender
  set m lput "Prev-Initialize" m         ; sender's message

  set WA_State_Sounds-Previous_Cycle lput m WA_State_Sounds-Previous_Cycle
;  show "sounds-previous-initialize"
end

to WA_brf_sounds-prey_found ; Establishes a unique call from an HA that a PA has been identified...represents a unique sound.

  let m []
  set m lput [who] of self m
  set m lput [label] of self m
  set m lput [xcor] of self m
  set m lput [ycor] of self m
  set m lput [GA_State_Voice-Level] of self m
  set m lput "WA_brf_sounds-prey_found-1" m

  set WA_State_Sounds-Current_Cycle lput m WA_State_Sounds-Current_Cycle
;  show "WA_brf_sounds-prey_found"

;  foreach WA_State_Sounds-Current_Cycle [ [n] ->
;    let sound-level (item 3 n)
;    let message (item 4 n)
;    show [(word "("message", "sound-level ")")] of self
;  ]
end

to WA_brf_sounds-update_Current-to-Previous ; transfers the sounds from this deliberation cycle to the next deliberation cycle
  set WA_State_Sounds-Previous_Cycle []
    let n []
;    let sender 0
;    let name "name"
;    let sound-x 0
;    let sound-y 0
 ;   let sound-level 0
;    let message "W"

  foreach WA_State_Sounds-Current_Cycle [ [m] ->
    set n[]
    set n lput (item 0 m) n       ; sender's agent number
    set n lput (item 1 m) n       ; sender's label
    set n lput (item 2 m) n       ; sender's xcor
    set n lput (item 3 m) n       ; sender's ycor
    set n lput (item 4 m) n       ; sender's sound level
    set n lput (item 5 m) n       ; sender's message

    set WA_State_Sounds-Previous_Cycle lput n WA_State_Sounds-Previous_Cycle
  ]

;  foreach WA_State_Sounds-Previous_Cycle [ [o] ->
;    let sound-level1 (item 3 o)
;    let message1 (item 4 o)
;    show ( word message1 "test" sound-level1)
;  ]

  set WA_State_Sounds-Current_Cycle [] ; clears the list
;  show "WA_brf_sounds-update_Current-to-Previous" ; [(word "brf_sounds - ("message")")] of self
;  set WA_State_Sounds-Current_Cycle but-first WA_State_Sounds-Current_Cycle
end

;;;;;;;;;;;;;;; Deliberation ;;;;;;;;;;;;;;;;
; Because the World Agent cannot automatically react to new perceptions, the BRF must be forced in the Deliberation process
; to ensure that the Beliefs are updated prior to the Desires, Plans, and Intentions being re-examined.
; Nomenclature: WA_deliberate_verb_subject

to WA_deliberate_clear ; clears the WA
  WA_irf_clear
end

to WA_deliberate_clear-ticks ; clears the WA's ticks
  WA_irf_clear-ticks
end

to WA_deliberate_cycle ; WA deliberation cycle (executed by clicking the "Go Once")
  ;; stop if the lead turtle is about to go out of the world
  ;if [patch-at 1 0] of hunters = nobody [ stop ]
 ; if ((remainder ticks 5) = 0) [(set ROx posx) (set ROy posy)]
  tick

  WA_Patch_deliberate_cycle-start

  ask hunted [
    PA_deliberate_cycle
  ]

  WA_Patch_deliberate_cycle-middle

  ask hunters [
    if WA_Belief_HA-Type = "Lionesses" [
      if HA_State_Hunter-Class = "Alpha" [
        HA_deliberate_lioness-alpha
      ]
      if HA_State_Hunter-Class = "Beta" [
        HA_deliberate_lioness-beta
      ]
    ]

    if WA_Belief_HA-Type = "Wolves" [
      if HA_State_Hunter-Class = "Alpha" [
        HA_deliberate_wolf-alpha
      ]
      if HA_State_Hunter-Class = "Beta" [
        HA_deliberate_wolf-beta
      ]
      if HA_State_Hunter-Class = "Omega" [
        HA_deliberate_wolf-omega
      ]
    ]
  ]

  WA_Patch_deliberate_cycle-end

  WA_brf_sounds-update_Current-to-Previous
  ask turtle 0 [show[(word "("pxcor ", " pycor")")] of self]
  ask turtle 1 [show[(word "("pxcor ", " pycor")")] of self]
  ask turtle 2 [show[(word "("pxcor ", " pycor")")] of self]
;  ask turtle 3 [show[(word "("pxcor ", " pycor")")] of self]
;  ask turtle 4 [show[(word "("pxcor ", " pycor")")] of self]
  show "***End of Turn"
end

to WA_deliberate_setup ; executed by clicking the Setup/Reset button
  WA_irf_clear
  WA_brf_setup
  WA_irf_setup
end

;;;;;;;;;;;;; Desire Review Funtion (DRF) ;;;;;;;;;;;;;;;;
; The World Agent has no desires of its own.

;--Desires--;
; The World Agent has no state level desires of its own.

;;;;;;;;;;;;;; Intention Review Function (IRF) ;;;;;;;;;;;;
; Nomenclature: WA_irf_verb_subject (refactoring still needs to be completed)

;--Intentions--;
; The World Agent has no state level intentions of its own.

;--IRF--;
to WA_irf_clear ; intention to clear the WA
  WA_plan_clear
end

to WA_irf_clear-ticks ; intention to clear the WA's ticks
  WA_action_clear-ticks
end

to WA_irf_setup ; intention to setup the WA
  WA_plan_setup
  WA_plan_setup-hunting_grounds
  WA_plan_hunters-setup
  WA_plan_prey-setup
end

;;;;;;;;;;;;;; Perceptions ;;;;;;;;;;
; This function consists of the selection boxes on the Interface GUI.
; With NetLogo, these objects broker variables which are handled by the BRF Function through a deliberation cycle.
; They are documented here for the purpose of completeness.
; Also, several procedures are coded here as they represent a forcing function which is activated through perception.
; Their primary function is for testing purposes.
; Nomenclature: WA_perceive_subject_verb

; Vegetation-Density     Slider from 1-100 used to set the density of vegetation.
; Rock-Density           Slider from 1-25 used to set the density of rock features.
; Water-Density          Slider from 1-25 used to set the density of water sources.
; Marsh-Density          Slider from 1-100 used to set the density of marsh lands.
; Wind-Direction         Chooser (Random, North, North-East, East, South-East, South, South-West, West, North-West) used to select the wind direction.
; Wind-Strength          Slider from 1-10 used to set the strength of the wind.
; Rain-Frequency
; Rain-Intensity

to WA_perception_hunters-clear ; clear the HAs from the WA
  WA_brf_hunters-die
end

to WA_perception_hunters-setup ; Instantiate the HAs within the WA
  WA_brf_hunters-instantiate
end

to WA_perception_prey-clear ; clear the PAs from the WA
  WA_brf_prey-die
end

to WA_perception_prey-setup ; Instantiate the PAs within the WA
  WA_brf_prey-instantiate
end

to WA_perception_setup-food ; Instantiate the food resources
  WA_brf_setup-food
end

to WA_perception_setup-vegetation ; Instantiate the vegetation resources
  WA_brf_setup-vegetation
end

to WA_perception_setup-rock_features ; Instantiate the rock features
  WA_brf_setup-rock_features
end

to WA_perception_setup-water ; Instantiate the water resources
  WA_brf_setup-water
end

to WA_perception_setup-river ; Instantiate the river
  WA_brf_setup-river
end

to WA_perception_setup-marsh; Instantiate the marsh features
  WA_brf_setup-marsh
end

to WA_perception_sounds-prey_found ; Used to broker a message from an HA to the WA about having found a PA
  WA_brf_sounds-prey_found
end

;;;;;;;;;;;;; Plans ;;;;;;;;;;;;
; Nomenclature: WA_perceive_subject_verb (refactoring still needs to be completed)

to WA_plan_clear ; clear the WA
  WA_action_clear-all
end

to WA_plan_setup ; instantiate the WA
  WA_action_setup-axes
end

to WA_plan_setup-hunting_grounds ; The hunting ground is set up according to the inputs of the various slider buttons
  WA_action_setup-statistical_features
  WA_action_setup-river
  WA_action_setup-marsh
end

to WA_plan_prey-setup ; instantiate the PAs
  WA_action_prey-setup
end

to WA_plan_hunters-setup ; instantiate the HAs
  WA_action_hunters-setup
end

;;-----------------------;;
;;;;;;; Patch Agent ;;;;;;;
;;-----------------------;;

;;;;;;;;;;; Belief Review Function (BRF) ;;;;;;;;;;;;;

; WA_Patch_State-Scent_Type        State: This variable holds the scent type that is on the patch. The types are neutral, hunter, and prey.
; WA_Patch_State-Scent_Level       State: This variable holds the scent level on the patch.
; WA_Patch_State-Grow_Time         State: This variable holds the growth rate of the vegetation patches.
; WA_Patch_State-Colour            State: This variable holds the patch's color when it was first instantiated.
; WA_Patch_State_Colour-Temp       State: This variable holds the patch's temporary color while it regrows.
; WA_Patch_State-Type              State: This variable holds the patch's type which is rock, vegetation, food, water, etc.
; WA_Patch_State-Sounds            State: This list holds the sounds (sound waves) that can be detected on the patch.
;                                           -  Sound Level 0     No sound
;                                           -  Sound Level 1     Whisper, only heard on the patch from which it originates and the adjoining patches.
;                                           -  Sound Level 2     Low Voice, only heard within 10 patch radius.
;                                           -  Sound Level 3     Normal Voice, heard within 50 patch radius.
;                                           -  Sound Level 4     Loud Voice, heard within 100 patch radius.
;                                           -  Sound Level 5     Yelling / barking, heard within 150 patch radius.
;                                           -  Sound Level 6     Howling, heard within 200 patch radius.
; WA_Patch_State_Agent-Number      State: This variable holds the unique turtle number of the PA or HA currently on the patch agent.
; WA_Patch_State_Agent-Heading     State: This variable holds the heading of the PA or HA currently on the patch agent.
; WA_Patch_State_Agent-Speed       State: This variable holds the speed of the PA or HA currently on the patch agent.

;;;;;;;;;;; Instantiation ;;;;;;;;;;;

to WA_Patch_brf_instantiate ; sets the parameters of the patches after instantiation
  if pcolor = orange [ set WA_Patch_State_Type "Food"         set WA_Patch_State_Colour orange    set WA_Patch_State_Colour-Temp  "None"]
  if pcolor = green  [ set WA_Patch_State_Type "Vegetation"   set WA_Patch_State_Colour green     set WA_Patch_State_Colour-Temp  "None"]
  if pcolor = grey   [ set WA_Patch_State_Type "Rock"         set WA_Patch_State_Colour grey      set WA_Patch_State_Colour-Temp  "None"]
  if pcolor = sky    [ set WA_Patch_State_Type "Water"        set WA_Patch_State_Colour sky       set WA_Patch_State_Colour-Temp  "None"]
  if pcolor = black  [ set WA_Patch_State_Type "Field"        set WA_Patch_State_Colour black     set WA_Patch_State_Colour-Temp  "None"]
end

;;;;;;;;;;; BRFs ;;;;;;;;;;;

to WA_Patch_brf_scent_fade ; Tracks and sets the scent levels at individual patches

  ask patches [
    if (WA_Patch_State_Scent-Type = "prey") [
      ;show [(word "("pxcor ", " pycor" , "WA_Patch_State-Scent_Level")")] of self

      ifelse (WA_Patch_State_Scent-Level = 0) [
        set WA_Patch_State_Scent-Type 0
;        if pcolor = yellow [ set pcolor black]
      ]
      [set WA_Patch_State_Scent-Level (WA_Patch_State_Scent-Level - 1)]
    ]
  ]
end

to WA_Patch_brf_scent_initialize ; initializes the scent on a patch when occupied by a PA or an HA
  ask patch-here [
;    if (pcolor = black) [ set pcolor yellow ]
    set WA_Patch_State_Scent-Type [GA_State_Scent-Type] of myself
    set WA_Patch_State_Scent-Level [GA_State_Scent-Level] of myself
  ]
end

to WA_Patch_brf_food-eat ; a result of the action that a PA has eaten the fruit on food source, sets the food source to the colour lime (indicating no food) and establishes a regrow time
  ask patch-here [
    set pcolor lime
    set WA_Patch_State_Colour-Temp lime
    set WA_Patch_State_Grow-Time 350
  ]
end

to WA_Patch_brf_food-grow ; decreases the regrow time by one unit. If the time period is zero then the food source has regrown and ready to be eaten again
  ask patches [
    if (WA_Patch_State_Colour-Temp = lime) [
      ifelse (WA_Patch_State_Grow-Time = 0) [
        set pcolor orange
        set WA_Patch_State_Colour-Temp "None"
      ][
        set WA_Patch_State_Grow-Time (WA_Patch_State_Grow-Time - 1)
      ]
    ]
  ]
end

;to WA_Patch_brf_HA-end
;  foreach WA_State_Patches-List [ [m] ->
 ;   ask patch (item 0 m) (item 1 m) [
;      if (pcolor = red) or (pcolor = 13) or (pcolor = 13) [ set pcolor WA_Patch_State_Colour ]
;    ]
;  ]
;end

to WA_Patch_brf_HA-start ; brokers the colour of the patches occupied by the HAs.
  set WA_State_Patches-List []
  ask hunters [
    let n []
    ask patch-here [
      if pcolor != 19 [
        ;set WA_Patch_State_Colour-Temp pcolor
        set pcolor [color] of myself
;      show pcolor
        set WA_Patch_State_Agent-Number [who] of myself
        set WA_Patch_State_Agent-Heading [heading] of myself
        set WA_Patch_State_Agent-Speed [ GA_State_Speed-Current ] of myself

        set n lput pxcor n
        set n lput pycor n
        set n lput WA_Patch_State_Agent-Number n
        set n lput WA_Patch_State_Agent-Heading n
        set n lput WA_Patch_State_Agent-Speed n
        ask myself [set WA_State_Patches-List lput n WA_State_Patches-List]
      ]
    ]
  ]
end

to WA_Patch_brf_kill_prey ; brokers the colour of a patch where a prey has been killed.
  ask patch-here [
;    set WA_Patch_State_Colour 19
    set pcolor 19
    show "HA and PA on same Patch"
  ]
end

;to WA_Patch_brf_PA-end
;  foreach WA_State_Patches-List [ [m] ->
;    ask patch (item 0 m) (item 1 m) [
;      if (pcolor = brown) [ set pcolor WA_Patch_State_Colour ]
;    ]
;  ]
;end

to WA_Patch_brf_PA/HA-end ; brokers the colours of the patches occupied by PAs and HAs and returns them to their original colours at the start of the deliberation cycle.
  foreach WA_State_Patches-List [ [m] ->
    ask patch (item 0 m) (item 1 m) [
      if (pcolor = red) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

      if (pcolor = 13) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

      if (pcolor = 14) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

      if (pcolor = 16) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

      if (pcolor = 19) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

      if (pcolor = brown) [
        set pcolor WA_Patch_State_Colour
        if (WA_Patch_State_Colour-Temp = lime) [set pcolor WA_Patch_State_Colour-Temp]
      ]

;       if (pcolor = red) or (pcolor = 13) or (pcolor = 14) or (pcolor = 16) or (pcolor = 19) or (pcolor = brown) [
;        ifelse (WA_Patch_State_Colour = lime) [
;          set pcolor WA_Patch_State_Colour-Temp
 ;       ][
 ;         set pcolor WA_Patch_State_Colour
 ;       ]
      ;]
    ]
  ]
end

to WA_Patch_brf_PA-start ; brokers the colour of a patch occupied by a PA.
;  set WA_State_Patches-List []
  ask hunted [
    let n []
    ask patch-here [
      if pcolor != 19 [
        ;set WA_Patch_State_Colour pcolor
        set pcolor [color] of myself
        show pcolor
        set WA_Patch_State_Agent-Number [who] of myself
        set WA_Patch_State_Agent-Heading [heading] of myself
        set WA_Patch_State_Agent-Speed [ GA_State_Speed-Current ] of myself

        set n lput pxcor n
        set n lput pycor n
        set n lput WA_Patch_State_Agent-Number n
        set n lput WA_Patch_State_Agent-Heading n
        set n lput WA_Patch_State_Agent-Speed n
        ask myself [set WA_State_Patches-List lput n WA_State_Patches-List]
      ]
    ]
  ]
end

to WA_Patch_brf_sounds ; brokers sounds on the patches occupied by PAs and HAs.
  let sender 0
  let name "name"
  let sound-x 0
  let sound-y 0
  let sound-level 0
  let message "none"
  let sound-distance 0

  let n []

  ask turtles [
    ask patch-here [
      set WA_Patch_State_Sounds []
      set n []
      foreach WA_State_Sounds-Previous_Cycle [ [m] ->
        set sender (item 0 m)
        set name (item 1 m)
        set sound-x (item 2 m)
        set sound-y (item 3 m)
        set sound-level (item 4 m)
        set message (item 5 m)

;             show [(word "brf_sounds - ("sound-level")")] of self

        set sound-distance (sqrt( ((pxcor - sound-x) ^ 2) + ((pycor - sound-y) ^ 2) ))
;        show [(word "sender - ("sender") and sound-distance - ("sound-distance") and initial sound-level - ("sound-level")")] of self

        if ((sound-distance >= 0) and (sound-distance <= 2)) and sound-level >= 1 [
          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;           show [(word "patch sound-level - ("sound-level")")] of self
          ]

        if ((sound-distance > 2) and ( sound-distance <= 5)) and sound-level >= 2 [ ;((sound-level > 1) and (sound-level <= 2)) [
          set sound-level (sound-level - 1)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;           show [(word "patch sound-level - ("sound-level")")] of self
          ]

        if ((sound-distance > 5) and ( sound-distance <= 10)) and sound-level >= 3 [ ;((sound-level > 2) and (sound-level <= 3)) [
          set sound-level (sound-level - 2)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
           show [(word "patch sound-level - ("sound-level")")] of self
        ]

        if ((sound-distance > 10) and ( sound-distance <= 50)) and sound-level >= 4 [ ;((sound-level > 3) and (sound-level <= 4)) [
          set sound-level (sound-level - 3)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;           show [(word "patch sound-level - ("sound-level")")] of self
        ]

        if ((sound-distance > 50) and ( sound-distance <= 100)) and sound-level >= 5 [ ;((sound-level > 4) and (sound-level <= 5)) [
          set sound-level (sound-level - 4)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;           show [(word "patch sound-level - ("sound-level")")] of self
        ]

        if ((sound-distance > 100) and ( sound-distance <= 150)) and sound-level >= 6 [ ;((sound-level > 5) and (sound-level <= 6)) [
          set sound-level (sound-level - 5)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;           show [(word "patch sound-level - ("sound-level")")] of self
        ]

        if ((sound-distance > 150) and ( sound-distance <= 200)) and sound-level >= 7 [ ;((sound-level > 6) and (sound-level <= 7)) [
          set sound-level (sound-level - 6)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
           show [(word "patch sound-level - ("sound-level")")] of self
        ]

        if ((sound-distance > 200) and ( sound-distance <= 250)) and sound-level >= 8 [ ;((sound-level > 7) and (sound-level <= 8)) [
          set sound-level (sound-level - 7)

          set n lput sender n
          set n lput name n
          set n lput sound-x n
          set n lput sound-y n
          set n lput sound-level n
          set n lput message n

          set WA_Patch_State_Sounds lput n WA_Patch_State_Sounds
;          show [(word "patch sound-level - ("sound-level")")] of self
        ]
      ]
;          foreach WA_Patch_State_Sounds [ [o] ->
;            set message (item 4 o )
;            show [(word "Patch_State_Sounds - ("message")")] of self
;          ]

    ]
  ]

end

;;;;;;;;;;; Deliberate ;;;;;;;;;;;

to WA_Patch_deliberate_cycle-end ; handles the beliefs that need to be updated on the patches occupied by PAs and HAs at the end of the deliberation cycle.
  WA_Patch_brf_PA/HA-end
  ;WA_Patch_brf_HA-end
  ;WA_Patch_brf_PA-end
end

to WA_Patch_deliberate_cycle-middle ; handles the beliefs that need to be updated on the patches occupied by PAs in the middle of the deliberation cycle.

  WA_Patch_brf_PA-start
end

to WA_Patch_deliberate_cycle-start ; handles the beliefs that need to be updated on the patches occupied by HAs at the start of the deliberation cycle...this includes updating sounds, scent, and food growth.
  WA_Patch_brf_sounds
  WA_Patch_brf_HA-start
  WA_Patch_brf_scent_fade
  WA_Patch_brf_food-grow
end

;;;;;;;;;;;;;; Perceptions ;;;;;;;;;;
; Perceptions by a Patch Agent represent a forcing function of an action taken against the patch.

to WA_Patch_perception_food-eaten ; this is a forcing function initiated by a PA eating the food on the patch.
  WA_Patch_brf_food-eat
end

to WA_Patch_perception-kill_prey ; the patch perceives that a PA has died on it.
  WA_Patch_brf_kill_prey
end

to WA_Patch_perception_scent-initialize ; the patch perceives that a PA or HA has occupied it and left a scent.
  WA_Patch_brf_scent_initialize
end

;to WA_Patch_perception_sounds
;  WA_Patch_brf_sounds
;end

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;-----------------------;;
;;;;;; Generic Agent ;;;;;;
;;-----------------------;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

;The Generic Agent defines states and procedures that are common to both Hunter and Prey Agents.
;As NetLogo does not yet have Super Classes (and thus Inheritance), the Generic Agent fills this role.
;It is used as a means to re-use code, increasing both coding efficiency and simplicity (in both reading the code and evolving it).

;;;;;;;;; Actions ;;;;;;;;;;;;;;
; Nomenclature: GA_action_subject_verb     if the subject is the Agent, then it is omitted.

to GA_action_move-none ; The GA remains stationary on the patch which simulates resting
  show "Do Nothing"
  set GA_State_Energy-Current (GA_State_Energy-Current - 1)
  set GA_State_Water-Current (GA_State_Water-Current - 1)
  WA_Patch_perception_scent-initialize
end

to GA_action_move-normal ; This is the normal movement speed of the agents in the WA
  fd 1
  set GA_State_Energy-Current (GA_State_Energy-Current - 2)
  set GA_State_Water-Current (GA_State_Water-Current - 2)
  WA_Patch_perception_scent-initialize
end

to GA_action_move-quick ; This represents a fast walk for the agents
  fd 2
  ; fd 1
  ; fd 1
  set GA_State_Energy-Current (GA_State_Energy-Current - 3)
  set GA_State_Water-Current (GA_State_Water-Current - 3)
  WA_Patch_perception_scent-initialize
end

to GA_action_move-fast ; This represents a speed walk for the agents
  fd 3
  set GA_State_Energy-Current (GA_State_Energy-Current - 4)
  set GA_State_Water-Current (GA_State_Water-Current - 4)
  WA_Patch_perception_scent-initialize
end

to GA_action_move-run ; This represents a slow run (jog) for the agents
  fd 5
  set GA_State_Energy-Current (GA_State_Energy-Current - 5)
  set GA_State_Water-Current (GA_State_Water-Current - 5)
  WA_Patch_perception_scent-initialize
end

to GA_action_move-sprint ; This represents an all out run (ie. sprint) for the agents
  fd 7
  set GA_State_Energy-Current (GA_State_Energy-Current - 6)
  set GA_State_Water-Current (GA_State_Water-Current - 6)
  set GA_State_Exhaustion 20
  WA_Patch_perception_scent-initialize
end

to GA_action_move-pounce_prey ; This represents a pouncing action of an HA onto a PA. It is the physical displacement of the HA from one patch to another
  move-to patch HA_Belief_Prey-X HA_Belief_Prey-Y
end

to GA_action_turn-around ; The agent turns course by 180 degrees
  let heading-temp heading
  set heading (remainder int ((heading-temp) + 180) 360)
end

;;;;;;;;;;; Belief Review Function (BRF) ;;;;;;;;;;;;;
; The Beliefs of the Generic Agent are detailed under the Beliefs / Turtles-Own section of the World Agent.
; This occurs because NetLogo requires these variables to be declared at the beginning of the code (for reasons unknown).
; Though the class of generic agent variables are not formally declared at this location in the code, they are described below:

;--Beliefs--;
;  GA_Design_Speed-Max                   Design: the Agent's maximum possible speed.
;  GA_State_Speed-Current                State: the Agent's current speed.
;  GA_Design_Energy-Max                  Design: the maximum Energy that the Agent can store.
;  GA_State_Energy-Current               State: the Agent's current energy reserve.
;  GA_Belief_Hunger-Level                Belief: the Agent's hunger level. The level is dependent on the amount of energy in reserve. The lower the energy reserve, the higher the hunger level.
;  GA_Design_Hearing-Level-Min           Design: this is the minimum sound level that the Agent is able to perceive (measured at the Agent's location (ie: the Agent's ears)).
;  GA_Design_Vocal-Level-Max             Design: this is the sound level of the Agent's voice (measured at the Agent's location (ie: the Agent's mouth)).
;  GA_Design_Scent-Level-Min             Design: this is the minimum scent level that the Agent is able to perceive.
;  GA_State_Scent-Type                   State: This is the type of scent that the Agent possesses. The types are either prey or hunter.
;  GA_State_Scent-Level                  Belief: this is the Agent's scent level. The scent level increases with the Agent's age.
;  GA_Design_Vision-Max                  Belief: the maximum distance that the Agent can perceive objects.
;  GA_State_Water-Current                State: the Agent's current water reserve.
;  GA_Belief_Water-Level                 Belief: the Agent's thirst level.
;  GA_Belief_Water-Bearing               Belief: the bearing to the nearest water source.
;  GA_Belief_Patch-Colour                Belief: the colour of the patch (WA_Patch_State-Colour) that the Agent is occupying. This variable holds the patch colour at the start of the cycle and restores it at the end.
;  GA_Belief_Patch-Type                  Belief: the type of patch (WA_Patch_State-Type) that the Agent is occupying.
;  GA_State_Voice-Level                  State: This is the voice level of the Agent.
;                                           -  Sound Level 0     No sound
;                                           -  Sound Level 1     Whisper, only heard on the patch from which it originates and the adjoining patches.
;                                           -  Sound Level 2     Low Voice, only heard within 10 patch radius.
;                                           -  Sound Level 3     Normal Voice, heard within 50 patch radius.
;                                           -  Sound Level 4     Loud Voice, heard within 100 patch radius.
;                                           -  Sound Level 5     Yelling / barking, heard within 150 patch radius.
;                                           -  Sound Level 6     Howling, heard within 200 patch radius.
;  GA_State_Exhaustion                   State: The Agent is exhausted - True/False.
;  GA_State_Agent-Type                   State: The type of Agent: PA / HA.
;  GA_State_Agent-Class                  State: The class of Agent: For PA (Adult or Adolescent). For HA (Alpha, Beta, Omega).
;  GA_State_Scan-Distance                State: this variable is the distance upon which the eyes focus...representing the control of the nerves upon the retina.
;                                                It is a state because it represents a physical state of the optical reception capability.
;  GA_Perceive_Visual-Scan               Perception: This variable holds the perceived data from the eyes.

;--BRF--;

to GA_brf_cycle ; The agent begins its cycle
  set GA_Belief_Water false
  set GA_Belief_Water-atSource false
  set GA_Belief_Water-Distance 100
  set GA_State_Exhaustion (GA_State_Exhaustion - 1 )
end

to GA_brf_disposition ; Returns the agent to its original properties
  ask patch-here [ ; determines the patch that the Agent is standing on
    ask myself [ set GA_Belief_Patch-Colour WA_Patch_State_Colour     set GA_Belief_Patch-Type WA_Patch_State_Type ]
  ]
end

to GA_brf_hunger-level ; sets the hunger level of the agent
  if (0 < GA_State_Energy-Current) and (GA_State_Energy-Current < 25) [set GA_Belief_Hunger-Level 4]
  if (24 < GA_State_Energy-Current) and (GA_State_Energy-Current < 50) [set GA_Belief_Hunger-Level 3]
  if (49 < GA_State_Energy-Current) and (GA_State_Energy-Current < 75) [set GA_Belief_Hunger-Level 2]
  if (74 < GA_State_Energy-Current) and (GA_State_Energy-Current < 100) [set GA_Belief_Hunger-Level 1]
  if (99 < GA_State_Energy-Current) and (GA_State_Energy-Current < 150) [set GA_Belief_Hunger-Level 0]
end

to GA_brf_thirst-level ; sets the thirst level of the agent
  if (0 < GA_State_Water-Current) and (GA_State_Water-Current < 25) [set GA_Belief_Water-Level 4]
  if (24 < GA_State_Water-Current) and (GA_State_Water-Current < 50) [set GA_Belief_Water-Level 3]
  if (49 < GA_State_Water-Current) and (GA_State_Water-Current < 75) [set GA_Belief_Water-Level 2]
  if (74 < GA_State_Water-Current) and (GA_State_Water-Current < 100) [set GA_Belief_Water-Level 1]
  if (99 < GA_State_Water-Current) and (GA_State_Water-Current < 151) [set GA_Belief_Water-Level 0]

end

to GA_brf_water ; reviews the agent's belief as to the location of the nearest water feature
  let temp-heading 0
  let temp-distance 100
  let patch-colour 0

  let n first GA_Perceive_Visual-Scan
  set GA_Belief_Patch-Colour (item 0 n)

  ifelse (GA_Belief_Patch-Colour = blue) or (GA_Belief_Patch-Colour = sky) or (GA_Belief_Patch-Colour = 42)[
;    show "at water"
    set GA_Belief_Water-atSource true ][
    foreach GA_Perceive_Visual-Scan [ [m] ->
        set patch-colour (item 0 m)
        if (patch-colour = blue) or (patch-colour = sky) or (patch-colour = 42) [
 ;         show "found water"
          (set GA_Belief_Water true)
          (set temp-heading (item 1 m))
          (set temp-distance (item 2 m))

          if (temp-distance < GA_Belief_Water-Distance) [
            set GA_Belief_Water-Distance temp-distance
            set GA_Belief_Water-Heading temp-heading
          ]
        ]
      ]
    ]

 ; show [(word "( "GA_Belief_Water-Heading" , "GA_Belief_Water-Distance" )")] of self

  if (GA_Belief_Water = false)[
    ifelse (ycor >= 0)[set GA_Belief_Water-Heading 180 set GA_Belief_Water true show "water at 180"][set GA_Belief_Water-Heading 0 set GA_Belief_Water true show "water at 0"]
  ]

end

;;;;;;;;;;;;;;; Deliberation ;;;;;;;;;;;;;;;;

to GA_deliberate_cycle ; runs one cycle of the agent's deliberation cycle
  GA_brf_hunger-level
  GA_brf_thirst-level
  GA_drf_food
  GA_drf_water
end

;;;;;;;;;;;;; Desire Review Function (DRF) ;;;;;;;;;;;;;;;;

;--Desires--;
;  GA_Desire_Food                        Desire: does the Agent desire food?
;  GA_Desire_Water true                  Desire: does the Agent desire water?
;  GA_Desire_Evade                       Desire: Does the Agent desire to evade the situation. States are True or False.

;--DRF--;

to GA_drf_food ; sets the agents desire for food
  if GA_Belief_Hunger-Level = 4 [set GA_Desire_Food true]
  if GA_Belief_Hunger-Level = 3 [set GA_Desire_Food true]
  if GA_Belief_Hunger-Level = 2 [set GA_Desire_Food true]
  if GA_Belief_Hunger-Level = 1 [set GA_Desire_Food true]
  if GA_Belief_Hunger-Level = 0 [set GA_Desire_Food false]
end

to GA_drf_water ; sets the agents desire for water
  if GA_Belief_Water-Level = 4 [set GA_Desire_Water true]
  if GA_Belief_Water-Level = 3 [set GA_Desire_Water true]
  if GA_Belief_Water-Level = 2 [set GA_Desire_Water true]
  if GA_Belief_Water-Level = 1 [set GA_Desire_Water true]
  if GA_Belief_Water-Level = 0 [set GA_Desire_Water false]
end

;;;;;;;;;;;;;; Intention Review Function (IRF) ;;;;;;;;;;;;
; Nomenclature: GA_irf_verb_subject

to GA_irf_turn-and-run ; the agent turns heading 180 degrees and sprints away from that patch
  show "run-away!"
  GA_action_turn-around
  GA_action_move-sprint
;  GA_action_turn-around
end

;;;;;;;;;;;;;; Perceptions ;;;;;;;;;;
; Because perceptions are very individualistic to a PA or HA, these were coded in those areas.

to GA_perceive ; To be developed

end

;;;;;;;;;;;;;; Plans ;;;;;;;;;;;;
; Plans where also unique to a type of PA or HA...representing their unique abilities.

;to GA_plan_turn-and-run
;  show "run-away!"
;  GA_action_turn-around
;  GA_action_move-sprint
;  GA_action_turn-around
;end

;;-----------------------;;
;;;;;; Prey Agent ;;;;;;
;;-----------------------;;

; The Prey Agent represents an adult or adolescent prey depending on how it is instantiated.
; The command "breed [ hunted prey]" is defined in the World Agent / Beliefs section as required by NetLogo.

;;;;;;;;; Actions ;;;;;;;;;;;;;;
; Nomenclature: PA_action_subject_verb     if the subject is the Agent, then it is omitted.

to PA_action_eat-food  ; PA eats food thus increasing its energy level by consuming a patch
;  show "eating food"
  set GA_State_Energy-Current 150
  WA_Patch_perception_food-eaten
end

to PA_action_drink-water ; PA drinks water thus increasing its water level...no patch is consumed.
;  show "drinking water"
  set GA_State_Water-Current 150
end

to PA_action_kill-prey  ; PA is dying as a result of being killed by an HA. The PA and HA occupy the same patch.
  WA_Patch_perception-kill_prey
end

;;;;;;;;;;;;; Belief Review Function (BRF) ;;;;;;;;;;;;;;;;

; The Beliefs of the Prey Agent are instantiated under the Beliefs / Hunted-Own section of the World Agent.
; This occurs because NetLogo requires these variables to be declared at the beginning of the code (for reasons unknown).
; Though the class of hunted variables are not formally declared at this location in the code, they are described below:

;--Beliefs--;
;  PA_Belief_Food                     Belief: the Agent believes (true/false) that it has perceived food.
;  PA_Belief_Food-Heading             Belief: this is the heading of perceived food.
;  PA_Belief_Food-Distance            Belief: this is the distance of the food from the Agent.
;  PA_Belief_Food-Sources             Belief: this is the Agent's list of known food sources.
;  PA_Belief_Food-atSource            Belief: true/false, the Agent is geolocated with a food source.

;  PA_Belief_Water                    Belief: the Agent believes (true/false) that it has perceived water.
;  PA_Belief_Water-Heading            Belief: this is the heading of perceived water.
;  PA_Belief_Water-Distance           Belief: this is the distance of the water from the Agent.
;  PA_Belief_Water-Sources            Belief: this is the Agent's list of known water sources.
;  PA_Belief_Water-atSource           Belief: true/false, the Agent is geolocated with a water source.

;  PA_Belief_Hunter                   Belief: the Agent believes (true/false) that it has perceived a hunter.
;  PA_Belief_Hunter-Heading           Belief: this is the heading of the perceived hunter.
;  PA_Belief_Hunter-Distance          Belief: this is the distance of the hunter from the Agent.
;  PA_Belief_Hunter-Sees-Me           Belief: the Agent believes (true/false) that it is being observed by the hunter. (Not Used)
;  PA_Belief_Hunter-atSource          Belief: true/false, the Prey Agent is geolocated with a Hunter Agent.

;  PA_Belief_Move-Next_Heading        Belief: this is the heading that the prey prefers to follow on its next movement. (Not Used)
;  PA_Belief_Move-Next_Distance       Belief: this is the number of squares that the Prey can move before it needs to reassess its next steps. (Not Used)

;--Instantiation--;
to PA_belief_instantiate-hunted_prey_adult ; instantiate an adult Prey Agent

  create-hunted 1
    [ set color brown
      set size 7
      set shape "default"
      set pen-size 1

      setxy 0 10 ;random-xcor random-ycor
;      set heading 180
      ;pen-down
;      facexy 0 1

      set label who
      set label-color white
      set heading 180
      set GA_State_Energy-Current 75
      set GA_State_Water-Current 150
      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
      set GA_State_Scent-Type "prey"
      set GA_State_Scent-Level 100
      set GA_State_Exhaustion 0
      set PA_Belief_Hunter-atSource false

      set PA_Belief_Food-Sources []
      set GA_Belief_Water-Sources []
    ]
end

to PA_belief_instantiate-hunted_prey_adolescent ; instantiate an adolescent Prey Agent
  create-hunted 1
    [ set color orange
      set size 3
      set shape "default"
      set pen-size 1

      setxy 25 25
      facexy 0 1

      set label who
      set label-color black

      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
    ]
end

;--BRF--;
to PA_brf_cycle ; resets the PA's beliefs at the start of the deliberation cycle
  set PA_Belief_Food false
  set PA_Belief_Food-atSource false
  set PA_Belief_Food-Distance 100
  set PA_Belief_Hunter false
  set PA_Belief_Hunter-Distance 100
  GA_brf_cycle

  PA_perception_visual-scan

end

to PA_brf_food ; identify food within the visual scan
  let temp-heading 0
  let temp-distance 100
  let patch-colour 0

  let n first GA_Perceive_Visual-Scan
  set GA_Belief_Patch-Colour (item 0 n)

  ifelse (GA_Belief_Patch-Colour = orange)[
;    show "at food"
    set PA_Belief_Food-atSource true
  ][
    foreach GA_Perceive_Visual-Scan [ [m] ->
      set patch-colour (item 0 m)
      if (patch-colour = orange) [
;        show "found food"
        (set PA_Belief_Food true)
        (set temp-heading (item 1 m))
        (set temp-distance (item 2 m))

        if (temp-distance < PA_Belief_Food-Distance) [
          set PA_Belief_Food-Distance temp-distance
          set PA_Belief_Food-Heading temp-heading
        ]
      ]
    ]
  ]

end

to PA_brf_hunter ; identify HA's within the visual scan
  let temp-heading 0
  let temp-distance 100
  let patch-colour 0

  let n first GA_Perceive_Visual-Scan
  set GA_Belief_Patch-Colour (item 0 n)
;  show [(word "("GA_Belief_Patch-Colour")")] of self

  ifelse (GA_Belief_Patch-Colour = red)[
    show "I'm being attacked!"
    set PA_Belief_Hunter-atSource true
  ][
    foreach GA_Perceive_Visual-Scan [ [m] ->
      set patch-colour (item 0 m)
      if (patch-colour = red) [
        show "found hunter"
        (set PA_Belief_Hunter true)
        (set temp-heading (item 1 m))
        (set temp-distance (item 2 m))

        if (temp-distance < PA_Belief_Hunter-Distance) [
          set PA_Belief_Hunter-Distance temp-distance
          set PA_Belief_Hunter-Heading temp-heading
;          show [(word "(" PA_Belief_Hunter-Heading ", " PA_Belief_Hunter-Distance")")] of self
        ]
      ]
    ]
  ]

end

;;;;;;;;;;;;;;; Deliberation ;;;;;;;;;;;;;;;;

to PA_deliberate_cycle ; main PA deliberation cycle

  PA_brf_cycle

  PA_brf_hunter

  PA_drf_hunter

  if PA_Belief_Hunter-atSource = true [
    PA_irf_kill-prey
  ]

  if PA_Belief_Hunter-atSource = false [
    if GA_State_Exhaustion <= 0 [
      ifelse (GA_Desire_Evade = true) [
        PA_irf_evade-turn-and-run
      ][
        GA_deliberate_cycle
        PA_drf_food-or-water
;    show [(word "("GA_Desire_Food " , "GA_Desire_Water " , "PA_Desire_Hunger-Thirst " , "GA_State_Energy-Current " , "GA_State_Water-Current ")")] of self
        let heading-set false

        if (GA_Desire_Water = true) [
;      show "Water"
          GA_brf_water
;      show [(word "( "GA_Belief_Water" )")] of self
          if GA_Belief_Water-atSource = true [PA_irf_drink-water]
            if (GA_Belief_Water = true) and (GA_Belief_Water-atSource = false) [
              PA_irf_move-water
              set heading-set true
            ]
          ]

        if (GA_Desire_Food = true) and (PA_Desire_Hunger-Thirst = "Food")[
;      show "Food"
          PA_brf_food
;      show [(word "( "PA_Belief_Food" )")] of self
          if PA_Belief_Food-atSource = true [PA_irf_eat-food]
          if PA_Belief_Food = true and (PA_Belief_Food-atSource = false)[
            PA_irf_move-food
            set heading-set true
          ]
        ]

        if ((GA_Desire_Water = true) or (GA_Desire_Food = true) and (PA_Belief_Food = false) and (GA_Belief_Water = false) and (heading-set = false)) [PA_irf_move-search_circle]

        if ((GA_Desire_Food = false) and (GA_Desire_Water = false)) [PA_irf_relax]
      ]
    ]
  ]
end

;;;;;;;;;;;;; Desire Review Function (DRF) ;;;;;;;;;;;;;;;;

;--Desires--;
; PA_Desire_Hunger-Thirst             Desire: Does the Agent desire food or water above the other. States are "Food" or "Water".

to PA_drf_food-or-water ; PA assesses whether it desires food and/or water
  ifelse (GA_Desire_Food = true) and (GA_Desire_Water = true) [set PA_Desire_Hunger-Thirst "Water"] [ set PA_Desire_Hunger-Thirst "Food" ]
end

to PA_drf_hunter ; In the presence of an HA, PA assesses that it has a desire to evade the HA
  ifelse (PA_Belief_Hunter = true) [set GA_Desire_Evade true][set GA_Desire_Evade false]
end

;;;;;;;;;;;;;; Intention Review Function (IRF) ;;;;;;;;;;;;
; Nomenclature: PA_irf_verb_subject

;--Intentions--;


;--IRF--;
to PA_irf_drink-water ; PA intends to drink water
  PA_action_drink-water
end


to PA_irf_eat-food ; PA intends to eat food
  PA_action_eat-food
end

to PA_irf_kill-prey ; PA intends to die (is dying)
  PA_action_kill-prey
end

to PA_irf_move-food ; PA intends to move towards a food source
  set heading PA_Belief_Food-Heading
  GA_action_move-normal
end

to PA_irf_move-search_circle ; PA intends to search for food
  set heading (heading + 10)
  GA_action_move-normal
end

to PA_irf_relax ; PA intends to do nothing
  GA_action_move-none
end

to PA_irf_move-water ; PA intends to move to a water source
  set heading GA_Belief_Water-Heading
  GA_action_move-normal
end

to PA_irf_evade-turn-and-run ; PA intneds to evade an HA
  GA_irf_turn-and-run
end

;;;;;;;;;;;;;; Perceptions ;;;;;;;;;;

;  PA_Perceive_Visual-Scan            Perception: this is a list of perceived objects during a visual scan.

to PA_perception_visual-scan ; PA's visual perception skill to see objects within the World Agent

  set GA_Perceive_Visual-Scan []

;;;;; Scan Agent's Patch;;;;;

  ask patch-here [ ; determines the patch that the Agent is standing on
    let m []
    set m lput pcolor m
    set m lput 0 m
    set m lput 0 m
    ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
  ]

;;;;; Center Scan;;;;;
  let i 1

  while [i <= 12] [
    ask patch-ahead i [ ; determines the patches in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 13) ]
    ]
    set i (i + 1)
  ]

;;;;; Left Scan;;;;;

  set i 1

  while [i <= 11] [
    ask patch-left-and-ahead 5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 12) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 15 i [ ; determines the patches left by 15 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 25 i [ ; determines the patches left by 25 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 35 i [ ; determines the patches left by 35 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 45 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 55 i [ ; determines the patches left by 55 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 65 i [ ; determines the patches left by 65 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 75 i [ ; determines the patches left by 75 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 85 i [ ; determines the patches left by 85 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-left-and-ahead 95 i [ ; determines the patches left by 95 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

;;;;; Right Scan;;;;;

  set i 1

  while [i <= 11] [
    ask patch-right-and-ahead 5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 12) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 15 i [ ; determines the patches right by 15 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 25 i [ ; determines the patches right by 25 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 35 i [ ; determines the patches right by 35 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 45 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 55 i [ ; determines the patches right by 55 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 65 i [ ; determines the patches right by 65 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 75 i [ ; determines the patches right by 75 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 85 i [ ; determines the patches right by 85 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 10] [
    ask patch-right-and-ahead 95 i [ ; determines the patches right by 95 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 11) ]
    ]
    set i (i + 1)
  ]

end

;;;;;;;;;;;;;; Plans ;;;;;;;;;;;;

;to PA_plan_food-moveto
;  set heading PA_Belief_Food-Heading
;  GA_action_move-normal
;end

;to PA_plan_food-water-search
;  set heading (heading + 10)
;  GA_action_move-normal
;end

;to PA_plan_water-moveto
;  set heading GA_Belief_Water-Heading
;  GA_action_move-normal
;end

;;-----------------------;;;
;;;;;;  Hunter Agent  ;;;;;;
;;-----------------------;;;

; The Hunter Agent consists of three classes of hunters:
;     1. Level-1 Hunter-Alpha
;     2. Level-2 Hunter-Beta
;     3. Level-3 Hunter-Omega
;
; The command "breed [ hunters hunter]" is defined in the World Agent / Beliefs section as required by NetLogo.
;

;;;;;;;;; Actions ;;;;;;;;;;;;;;

to HA_action_talk-prey_found ; HA communicates that it has found a PA thus simulating barking or howling
  show "HA-action_talk-prey_found"
  WA_perception_sounds-prey_found

end

to HA_action_eat-prey ; HA consumes a PA thus increasing its energy
  ;show "Eating Prey"
  set GA_State_Energy-Current 300
  ;figure out where an Agent dies!!!
;  WA_Patch_perception_food-eaten
end

to HA_action_face-alpha_heading ; HA turns and faces the Alpha HA
  set heading HA_Belief_Alpha-Heading
end

to HA_action_face-prey ; HA faces PA
    facexy HA_Belief_Prey-X HA_Belief_Prey-Y
end

to HA_action_kill-prey ; HA kills PA
  WA_Patch_perception-kill_prey
end

to HA_action_move-alpha ; HA moves towards Alpha HA
  facexy HA_Belief_Alpha-X HA_Belief_Alpha-Y
  GA_action_move-fast
end

to HA_action_move-encircle ; HA moves to encircle PA
  facexy HA_Belief_Encircle-X HA_Belief_Encircle-Y
  let x-dif (HA_Belief_Encircle-X - xcor)
  let y-dif (HA_Belief_Encircle-Y - ycor)

  let d sqrt( ((x-dif) ^ 2) + ((y-dif) ^ 2) )

  ifelse d >= 5 [
    GA_action_move-run
  ][
    HA_action_move-pounce_encircle
  ]
end

to HA_action_move-pounce_encircle ; moves the HA exactly onto the encircle point.

  if label = "Beta1" [
    move-to patch HA_Belief_Beta1-Encircle-X HA_Belief_Beta1-Encircle-Y
  ]

  if label = "Beta2" [
    move-to patch HA_Belief_Beta2-Encircle-X HA_Belief_Beta2-Encircle-Y
  ]

  if label = "Omega1" [
    move-to patch HA_Belief_Encircle-X HA_Belief_Encircle-Y
  ]
end

to HA_action_move-prey_fast ; HA moves fast towards the PA.
 set heading HA_Belief_Hunter-Prey_Heading
 GA_action_move-fast
end

to HA_action_move-prey_normal ; HA moves normal towards the PA.
  facexy HA_Belief_Prey-X HA_Belief_Prey-Y
  GA_action_move-normal
end

to HA_action_move-prey_pounce ; HA pounces on the PA.
  set heading HA_Belief_Hunter-Prey_Heading
  GA_action_move-pounce_prey
end

to HA_action-search-alpha ; HA moves its head/body to search for the Alpha HA.
  set heading (heading + 90)
end

to HA_action_search-prey ; HA moves to search for PA.
  set heading (heading + 10)
  GA_action_move-fast
end

;;;;;;;;;;;;; Belief Revision Function (BRF) ;;;;;;;;;;;;;;;;

; The Beliefs of the Hunter Agent are instantiated under the Beliefs / Hunters-Own section of the World Agent.
; This occurs because NetLogo requires these variables to be declared at the beginning of the code (for reasons unknown).
; Though the class of hunter variables are not formally declared at this location in the code, they are described below. Note that
; each belief exists within a cycle, where the cycles existing for this specific implementation are the Deliberate Cycle (DC), the
; Hunting Cycle (HC), and the Pack Cycle (PC) (where the Pack Cycle is used only to distinguish between the Alpha, Beta, and Omega Hunters).

;--Beliefs--;

;  HA_Belief_Prey-Seen                     Belief (DC): Prey has been visually observed - True/False.
;  HA_Belief_Prey-Known                    Belief (HC): HA has knowledge of the Prey's last known location. - True/False.
;  HA_Belief_Hunter-Prey_Heading           Belief (DC): Heading of HA to the prey.
;  HA_Belief_Hunter-Prey_Distance          Belief (DC): Distance from HA to prey.
;  HA_Belief_Prey-X                        Belief (HC): Prey's x-coord.
;  HA_Belief_Prey-Y                        Belief (HC): Prey's y-coord.
;  HA_Belief_Prey-Heading                  Belief (HC): Prey's heading.
;  HA_Belief_Prey-Speed                    Belief (HC): Prey's speed.
;  HA_Belief_Prey-atSource                 Belief (DC): The HA and the prey occupy the same patch.
;  HA_Belief_Prey-Sources                  Belief (HC): List of all the sources of prey (and their X,y coordinates).
;  HA_Belief_Leader                        Belief (PC): The turtle number of the HA's superior.
;  HA_Belief_Alpha                         Belief (PC): The turtle number of the Alpha.
;  HA_Belief_Alpha-Seen                    Belief (DC): Alpha has been visually observed - True/False.
;  HA_Belief_Alpha-Known                   Belief (HC): HA has knowledge of the Alpha's last location. - True/False.
;  HA_Belief_Hunter-Alpha_Heading          Belief (DC): The heading from the HA to the Alpha.
;  HA_Belief_Hunter-Alpha_Distance         Belief (DC): The distance from the HA to the Alpha.
;  HA_Belief_Alpha-X                       Belief (HC): The Alpha's x-coord.
;  HA_Belief_Alpha-Y                       Belief (HC): The Alpha's y-coord.
;  HA_Belief_Alpha-Heading                 Belief (HC): Alpha's heading.
;  HA_Belief_Alpha-Speed                   Belief (HC): Alpha's speed.
;  HA_Belief_Alpha-Prey_Distance           Belief (DC): The distance between the Alpha and the Prey.
;  HA_Belief_Alpha-Prey_Heading            Belief (DC): The heading from the Alpha and the Prey.
;  HA_Belief_Beta1                         Belief (PC): The turtle number of the Beta1.
;  HA_Belief_Beta1-Seen                    Belief (DC): Beta1 has been visually observed - True/False.
;  HA_Belief_Beta1-Known                   Belief (HC): HA has knowledge of the Beta1's last location. - True/False.
;  HA_Belief_Hunter-Beta1_Heading          Belief (DC): The heading from the HA to the Beta1.
;  HA_Belief_Hunter-Beta1_Distance         Belief (DC): The distance from the HA to the Beta1.
;  HA_Belief_Beta1-X                       Belief (HC): The Beta1's x-coord.
;  HA_Belief_Beta1-Y                       Belief (HC): The Beta1's y-coord.
;  HA_Belief_Beta1-Prey_Distance           Belief (DC): The distance between the Beta1 and the Prey.
;  HA_Belief_Beta1-Prey_Heading            Belief (DC): The heading from the Beta1 and the Prey.
;  HA_Belief_Beta1-Encircle-X              Belief (DC): X-coord of the Beta1 encircle point.
;  HA_Belief_Beta1-Encircle-Y              Belief (DC): Y-coord of the Beta1 encircle point.
;  HA_Belief_Beta2                         Belief (PC): The turtle number of the Beta2.
;  HA_Belief_Beta2-Seen                    Belief (DC): Beta2 has been visually observed - True/False.
;  HA_Belief_Beta2-Known                   Belief (HC): HA has knowledge of the Beta2's last location. - True/False.
;  HA_Belief_Hunter-Beta2_Heading          Belief (DC): The heading from the HA to the Beta2.
;  HA_Belief_Hunter-Beta2_Distance         Belief (DC): The distance from the HA to the Beta2.
;  HA_Belief_Beta2-X                       Belief (HC): The Beta2's x-coord.
;  HA_Belief_Beta2-Y                       Belief (HC): The Beta2's y-coord.
;  HA_Belief_Beta2-Prey_Distance           Belief (DC): The distance between the Beta2 and the Prey.
;  HA_Belief_Beta2-Prey_Heading            Belief (DC): The heading from the Beta2 and the Prey.
;  HA_Belief_Beta2-Encircle-X              Belief (DC): X-coord of the Beta2 encircle point.
;  HA_Belief_Beta2-Encircle-Y              Belief (DC): Y-coord of the Beta2 encircle point.
;  HA_Belief_Omega1                        Belief (PC): The turtle number of Omega1.
;  HA_Belief_Omega1-Seen                   Belief (DC): Omega1 has been visually observed - True/False.
;  HA_Belief_Omega1-Known                  Belief: HA has knowledge of the Omega1's last location. - True/False.
;  HA_Belief_Omega2                        Belief (PC): The turtle number of Omega2.
;  HA_Belief_Omega2-Seen                   Belief: Omega2 has been visually observed - True/False.
;  HA_Belief_Omega2-Known                  Belief: HA has knowledge of the Omega2's last location. - True/False.
;  HA_Belief_Heard-Call                    Belief (DC): HA heard a call from one of the other HAs.
;  HA_Belief_Heard-Alpha                   Belief (HC): HA heard a call from the Alpha.
;  HA_Belief_Encircle-X                    Belief (DC): X-coord of the encircle point.
;  HA_Belief_Encircle-Y                    Belief (DC): Y-coord of the encircle point.
;  HA_Belief_Hunt-Mode                     Belief (HC): The hunt mode that the HA is in: Rest, Search, Encircle, Strike, Eat.
;  HA_State_Hunter-Type                    State (PC): The type of Hunting Agent: lioness, wolf, etc.
;  HA_State_Hunter-Class                   State (PC): The class of hunter: alpha, beta, omega, etc.
;  HA_State_Hunter-Level                   State (PC): The level of the HA is used to distinguish two HAs of the same Class (ie. Beta1 from Beta2).

;--Instantiation--;
to HA_belief_instantiate-lioness_alpha ; instantiate the Alpha Lioness
  create-hunters 1
    [ set color red
      set size 5
      set shape "default"
      set pen-size 1

      setxy  0 0
      facexy 0 1

      set HA_State_Hunter-Type "Lioness"
      set HA_State_Hunter-Class "Alpha"
      set HA_Belief_Hunter-Leader [who] of self
      set HA_Belief_Beta1 1

      set label (word "Alpha" 1 )
      set label-color white

      set HA_Belief_Hunt-Mode "Rest"
      set GA_State_Energy-Current 75
      set GA_State_Water-Current 150
      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
      set GA_State_Voice-Level 7
    ]
end

to HA_belief_instantiate-lioness_beta ; Instantiate the Beta Lioness
  create-hunters 1 [
    set size 5
    set shape "default"
    set pen-size 1

    setxy 10 -10 ;
    facexy 0 1

    set HA_State_Hunter-Type "Lioness"
    set HA_State_Hunter-Class "Beta"

    set HA_Belief_Hunter-Leader 0

    set label (word "Beta" 1)
    set label-color white
    set color 13

    set HA_Belief_Hunt-Mode "Rest"
    set GA_State_Energy-Current 75
    set GA_State_Water-Current 150
    set GA_Design_Speed-Max 5
    set GA_State_Speed-Current 0
    set GA_State_Voice-Level 7
    ]
end

to HA_belief_instantiate-wolf_alpha ; Instantiate the Alpha Wolf
  create-hunters 1
    [ set color red
      set size 5
      set shape "default"
      set pen-size 1

      setxy 0 0 ;random-xcor random-ycor
      facexy 0 1

      set HA_Belief_Beta1 -1
      set HA_Belief_Beta2 -1
      set HA_Belief_Omega1 -1
      set HA_Belief_Omega2 -1

      set HA_State_Hunter-Type "Wolf"
      set HA_State_Hunter-Class "Alpha"
      set HA_Belief_Hunter-Leader [who] of self

      let i 0
      ask hunters [
        if (HA_State_Hunter-Class = "Alpha") [ set i (i + 1) ]
        set HA_State_Hunter-Level i
      ]

      set label (word "Alpha" WA_Belief_HA-Alpha_Quantity )
      set label-color white

;      show [(word "("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ")"  )] of self

      set HA_Belief_Hunt-Mode "Rest"
      set GA_State_Energy-Current 75
      set GA_State_Water-Current 150
      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
      set GA_State_Voice-Level 7
    ]
end

to HA_belief_instantiate-wolf_beta ; Instantiate the Beta Wolf
  create-hunters 1 [
;    set color 14
    set size 5
    set shape "default"
    set pen-size 1

  ;  setxy random-xcor random-ycor ; 0 0
    facexy 0 1

    set HA_Belief_Omega1 -1
    set HA_Belief_Omega2 -1

    set HA_State_Hunter-Type "Wolf"
    set HA_State_Hunter-Class "Beta"

    let i 0
    let j who
    ask hunters [
;   show [(word "Hunter - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ")"  )] of self
      if (HA_State_Hunter-Type = "Beta") [ set i (i + 1) ]
        let assigned false
        if (HA_State_Hunter-Type = "Alpha") [
          if HA_Belief_Beta1 = -1 [
            set HA_Belief_Beta1 j
            set assigned true
          ]
          if (assigned = false) and (HA_Belief_Beta2 = -1) [set HA_Belief_Beta2 j]
          set j who
;         show [(word "Alpha - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ", " HA_Belief_Hunter-Beta1 ", " HA_Belief_Hunter-Beta2 ")"  )] of self
        ]
      ]
      set HA_State_Hunter-Level i
      set HA_Belief_Hunter-Leader j

;      show [(word "Beta - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ", " who ")"  )] of self

      if WA_Belief_HA-Beta_Quantity = 2 [
        set label (word "Beta" 1 )
        set color 13
        setxy 10 -10
        show "my colour is 13"
      ]

      if WA_Belief_HA-Beta_Quantity = 1 [
        set label (word "Beta" 2 )
        set color 14
        setxy -10 -10
        show "my colour is 14"
      ]

      set HA_Belief_Hunt-Mode "Rest"
      set label-color white

      set GA_State_Energy-Current 75
      set GA_State_Water-Current 150
      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
      set GA_State_Voice-Level 7
    ]
end

to HA_belief_instantiate-wolf_omega ; Instantiate the Omega Wolf
  create-hunters 1
    [ set color 16
      set size 5
      set shape "default"
      set pen-size 1

      setxy random-xcor random-ycor ; 0 0
      facexy 0 1

      set HA_State_Hunter-Type "Wolf"
      set HA_State_Hunter-Class "Omega"

      let i 0
      let j who
      let k who
      let assigned false
      ask hunters [
;        set j k
;       show [(word "Hunter - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ")"  )] of self
        if (HA_State_Hunter-Type = "Omega") [ set i (i + 1) ]
;        set assigned false
        if (HA_State_Hunter-Type = "Alpha") and (assigned = false) [
          if HA_Belief_Omega1 = -1 [
            set HA_Belief_Omega1 j
            set k who
            set assigned true
          ]
          if (assigned = false) and (HA_Belief_Omega2 = -1)[
            set HA_Belief_Omega2 j
            set assigned true
            set k who
          ]
;          show [(word "Alpha/Beta - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ", " HA_Belief_Hunter-Omega1 ", " HA_Belief_Hunter-Omega2 ")"  )] of self
        ]

        if (HA_State_Hunter-Type = "Beta") and (assigned = false) [
          if HA_Belief_Omega1 = -1 [
            set HA_Belief_Omega1 j
            set k who
            set assigned true
          ]
          if (assigned = false) and (HA_Belief_Omega2 = -1)[
            set HA_Belief_Omega2 j
            set assigned true
            set k who
          ]

        ]
 ;       show [(word "Alpha/Beta - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ", " HA_Belief_Hunter-Omega1 ", " HA_Belief_Hunter-Omega2 ")"  )] of self
  ;      if assigned = true [set k who]
      ]
      set HA_State_Hunter-Level i
      set HA_Belief_Hunter-Leader k

 ;     show [(word "Me - ("HA_State_Hunter-Type ", " HA_State_Hunter-Level ", " HA_Belief_Hunter-Leader ", " who ")"  )] of self

      if WA_Belief_HA-Omega_Quantity = 1 [
        setxy 0 -25
      ]

      set label (word "Omega" WA_Belief_HA-Omega_Quantity )
      set HA_Belief_Hunt-Mode "Rest"
      set label-color white

      set GA_State_Energy-Current 75
      set GA_State_Water-Current 150
      set GA_Design_Speed-Max 5
      set GA_State_Speed-Current 0
      set GA_State_Voice-Level 7
    ]
end

;--BRF--;

to HA_brf_audio-update ; re-assess the audio perception
  let sender 0
  let name "name"
  let sound-x 0
  let sound-y 0
  let sound-level 0
  let message "none"
  let sound-bearing 0
  let hunter-distance 500

  HA_perception_sound

  foreach HA_Perceive-Sounds [ [m] ->
    set sender (item 0 m)
    set name (item 1 m)
    set sound-x (item 2 m)
    set sound-y (item 3 m)
    set sound-level (item 4 m)
    set message (item 5 m)

    if (sender != [who] of self) and (ticks >= 2)[    ;(turtle sender != [who] of self) ... (xcor != sound-x) and (ycor != sound-y)

      set HA_Belief_Heard-Call true

;      show "heard call"
;      show [(word "HA_brf_hunters-audio - (" sender ", " sound-x ", " sound-y ", " sound-level ")"  )] of self
      if (name = "Alpha1") [
;        show "heard Alpha"
        set HA_Belief_Heard-Alpha true
        set hunter-distance (distance turtle sender)
        if hunter-distance > 1 [
          set HA_Belief_Prey-Heading towardsxy sound-x sound-y
        ]
      ]
      if (HA_Belief_Heard-Alpha = false) and (distance turtle sender < hunter-distance) [
        set hunter-distance (distance turtle sender)
        if hunter-distance > 1 [
          set HA_Belief_Prey-Heading towardsxy sound-x sound-y
        ]
      ]
    ]
  ]

end

to HA_brf_cycle ; Resets the HA's beliefs at the start of the deliberation cycle
;  set HA_Belief_Prey false
;  set HA_Belief_Prey-atSource false
;  set HA_Belief_Hunter-Prey_Distance 100
;  set HA_Belief_Heard-Call false
;  set HA_Belief_Heard-Alpha false
;  set HA_Belief_Hunter-Leader false
;  set HA_Belief_Alpha false
;  set HA_Belief_Beta1 false
;  set HA_Belief_Beta2 false
;  set HA_Belief_Omega1 false

  GA_brf_cycle
  HA_perception_visual-scan
  HA_brf_visual-update
  HA_brf_audio-update

end

to HA_brf_lioness-spatial_update ; re-assesses the lioness's disposition wrt a PA and the other lioness
  let dx_alpha-prey (HA_Belief_Prey-X - HA_Belief_Alpha-X)
  let dy_alpha-prey (HA_Belief_Prey-Y - HA_Belief_Alpha-Y)

  set HA_Belief_Alpha-Prey_Distance (sqrt( ((dx_alpha-prey) ^ 2) + ((dy_alpha-prey) ^ 2) ))

  set HA_Belief_Encircle-X (HA_Belief_Prey-X + dx_alpha-prey)
  set HA_Belief_Encircle-Y (HA_Belief_Prey-Y + dy_alpha-prey)

  set HA_Belief_Beta1-Encircle-X HA_Belief_Encircle-X
  set HA_Belief_Beta1-Encircle-Y HA_Belief_Encircle-Y

  set HA_Belief_Beta1-Prey_Distance (sqrt( ((HA_Belief_Beta1-X - HA_Belief_Prey-X) ^ 2) + ((HA_Belief_Beta1-Y - HA_Belief_Prey-Y) ^ 2) ))
end

to HA_brf_wolf-spatial_update ; re-assesses the wolf's disposition wrt to the PA, Alpha and Beta wolves
  ;let dx_beta1-prey (HA_Belief_Prey-X - HA_Belief_Beta1-X)
  ;let dy_beta1-prey (HA_Belief_Prey-Y - HA_Belief_Beta1-Y)

  ;let dx_beta2-prey (HA_Belief_Prey-X - HA_Belief_Beta2-X)
  ;let dy_beta2-prey (HA_Belief_Prey-Y - HA_Belief_Beta2-Y)

  let dx_alpha-prey (HA_Belief_Prey-X - HA_Belief_Alpha-X)
  let dy_alpha-prey (HA_Belief_Prey-Y - HA_Belief_Alpha-Y)

  show [(word "Prey-X - ("HA_Belief_Prey-X") Prey-Y - ("HA_Belief_Prey-Y")"  )] of self
  show [(word "Alpha-X - ("HA_Belief_Alpha-X") Alpha-Y - ("HA_Belief_Alpha-Y")"  )] of self

  set HA_Belief_Alpha-Prey_Distance (sqrt( ((dx_alpha-prey) ^ 2) + ((dy_alpha-prey) ^ 2) ))

  if (label = "Beta1") or (label = "Alpha1") [
    set HA_Belief_Beta1-Encircle-X (HA_Belief_Prey-X + (HA_Belief_Alpha-Prey_Distance * 0.5))
    set HA_Belief_Beta1-Encircle-Y (HA_Belief_Prey-Y + (HA_Belief_Alpha-Prey_Distance * 1.2))

    set HA_Belief_Beta1-Prey_Distance (sqrt( ((HA_Belief_Beta1-X - HA_Belief_Prey-X) ^ 2) + ((HA_Belief_Beta1-Y - HA_Belief_Prey-Y) ^ 2) ))
    set HA_Belief_Encircle-X HA_Belief_Beta1-Encircle-X
    set HA_Belief_Encircle-Y HA_Belief_Beta1-Encircle-Y
  ]

  if label = "Beta2" or (label = "Alpha1") [
    set HA_Belief_Beta2-Encircle-X (HA_Belief_Prey-X + (HA_Belief_Alpha-Prey_Distance * -0.5))
    set HA_Belief_Beta2-Encircle-Y (HA_Belief_Prey-Y + (HA_Belief_Alpha-Prey_Distance * 1.2))

    set HA_Belief_Beta2-Prey_Distance (sqrt( ((HA_Belief_Beta2-X - HA_Belief_Prey-X) ^ 2) + ((HA_Belief_Beta2-Y - HA_Belief_Prey-Y) ^ 2) ))
    set HA_Belief_Encircle-X HA_Belief_Beta2-Encircle-X
    set HA_Belief_Encircle-Y HA_Belief_Beta2-Encircle-Y
  ]

  if label = "Omega1" [
   ; set HA_Belief_Encircle-X (HA_Belief_Prey-X + ((HA_Belief_Alpha-X + HA_Belief_Beta1-X + HA_Belief_Beta2-X) / 3))
   ; set HA_Belief_Encircle-Y (HA_Belief_Prey-Y + ((HA_Belief_Alpha-Y + HA_Belief_Beta1-Y + HA_Belief_Beta2-Y) / 3))

    set HA_Belief_Encircle-X ((HA_Belief_Alpha-X + HA_Belief_Beta1-X + HA_Belief_Beta2-X) / 3)
    set HA_Belief_Encircle-Y ((HA_Belief_Alpha-Y + HA_Belief_Beta1-Y + HA_Belief_Beta2-Y) / 3)

    show [(word "Omega-Encircle-X - ("HA_Belief_Encircle-X") Omega-Encircle-Y - ("HA_Belief_Encircle-Y")"  )] of self
    show [(word "Alpha-X - ("HA_Belief_Alpha-X") Alpha-Y - ("HA_Belief_Alpha-Y")"  )] of self
    show [(word "Beta1-X - ("HA_Belief_Beta1-X") Beta1-Y - ("HA_Belief_Beta1-Y")"  )] of self
    show [(word "Beta2-X - ("HA_Belief_Beta2-X") Beta2-Y - ("HA_Belief_Beta2-Y")"  )] of self

;    set HA_Belief_Omega-Prey_Distance (sqrt( ((HA_Belief_Beta1-X - HA_Belief_Prey-X) ^ 2) + ((HA_Belief_Beta1-Y - HA_Belief_Prey-Y) ^ 2) ))
  ]

end

to HA_brf_reset-beliefs ; resets beliefs to false
  set HA_Belief_Prey-Known false
  set HA_Belief_Alpha-Known false
  set HA_Belief_Beta1-Known false
  set HA_Belief_Beta2-Known false
  set HA_Belief_Omega1-Known false
  set HA_Belief_Omega2-Known false
end

to HA_brf_visual-update ; re-assesses the visual perception
  let patch-colour 0
  let temp-heading 0
  let temp-distance 100
  let temp-x 0
  let temp-y 0
  let agent-number 1000
  let agent-heading 1000
  let agent-speed 1000
  let i 0
  set HA_Belief_Hunter-Prey_Distance 110

  set HA_Belief_Prey-Seen false
  set HA_Belief_Prey-atSource false
;-  set HA_Belief_Hunter-Prey_Distance 100
;-  set HA_Belief_Heard-Call false
;-  set HA_Belief_Heard-Alpha false
;  set HA_Belief_Hunter-Leader false
  set HA_Belief_Alpha-Seen false
  set HA_Belief_Beta1-Seen false
  set HA_Belief_Beta2-Seen false
  set HA_Belief_Omega1-Seen false
  set HA_Belief_Alpha-Prey_Attack false

;  let n first GA_Perceive_Visual-Scan
;  set GA_Belief_Patch-Colour (item 0 n)
;  show [(word "(HA - "GA_Belief_Patch-Colour")")] of self

 ; ifelse (GA_Belief_Patch-Colour = brown) or (GA_Belief_Patch-Colour = 19) [
;    show "Captured Prey!"
;    set HA_Belief_Prey-atSource true
;  ][
  foreach GA_Perceive_Visual-Scan [ [m] ->
    set patch-colour (item 0 m)
    set temp-heading (item 1 m)
    set temp-distance (item 2 m)
    set temp-x (item 3 m)
    set temp-y (item 4 m)
    set agent-number (item 5 m)
    set agent-heading (item 6 m)
    set agent-speed (item 7 m)

    ifelse (i <= 0) [
      set GA_Belief_Patch-Colour patch-colour
      if (GA_Belief_Patch-Colour = brown) or (GA_Belief_Patch-Colour = 19) [
        show "Captured Prey!"
        set HA_Belief_Prey-atSource true
        set HA_Belief_Prey-Seen true
      ]
    ][
      if (patch-colour = brown) [
        set HA_Belief_Prey-Seen true
        show "found prey"

        if (temp-distance < HA_Belief_Hunter-Prey_Distance) [
          set HA_Belief_Hunter-Prey_Distance temp-distance
          set HA_Belief_Hunter-Prey_Heading temp-heading
          set HA_Belief_Prey-X temp-x
          set HA_Belief_Prey-Y temp-y
          show [(word "Visual-HA_Belief_Prey-X - ("HA_Belief_Prey-X") Visual-HA_Belief_Prey-Y - ("HA_Belief_Prey-Y")"  )] of self
        ]
      ]
      if (patch-colour = red) [
        set HA_Belief_Alpha-Seen true
        show "Visual Scan - I see Alpha"
        set HA_Belief_Alpha-Heading agent-heading
        set HA_Belief_Alpha-Speed agent-speed

        set HA_Belief_Hunter-Alpha_Heading temp-heading
        set HA_Belief_Hunter-Alpha_Distance temp-distance
        set HA_Belief_Alpha-X temp-x
        set HA_Belief_Alpha-Y temp-y
      ]
      if (patch-colour = 13) [
        set HA_Belief_Beta1-Seen true
        show "Visual Scan - I see Beta1"
        set HA_Belief_Hunter-Beta1_Heading temp-heading
        set HA_Belief_Hunter-Beta1_Distance temp-distance
        set HA_Belief_Beta1-X temp-x
        set HA_Belief_Beta1-Y temp-y
        show [(word "Visual-HA_Belief_Beta1-X - ("HA_Belief_Beta1-X") Visual-HA_Belief_Beta1-Y - ("HA_Belief_Beta1-Y")"  )] of self
      ]
      if (patch-colour = 14) [
        set HA_Belief_Beta2-Seen true
        show "Visual Scan - I see Beta2"
        set HA_Belief_Hunter-Beta2_Heading temp-heading
        set HA_Belief_Hunter-Beta2_Distance temp-distance
        set HA_Belief_Beta2-X temp-x
        set HA_Belief_Beta2-Y temp-y
        show [(word "Visual-HA_Belief_Beta2-X - ("HA_Belief_Beta1-X") Visual-HA_Belief_Beta2-Y - ("HA_Belief_Beta1-Y")"  )] of self
      ]
      if (patch-colour = 19) [                                    ; this represents an HA and PA on the same patch agent.
        set HA_Belief_Alpha-Seen true
        set HA_Belief_Prey-Seen true
        set HA_Belief_Alpha-Prey_Attack true
        set HA_Belief_Alpha-Prey_Distance 0
        show "Visual Scan - Alpha on Prey"
        set HA_Belief_Alpha-Heading agent-heading
        set HA_Belief_Alpha-Speed agent-speed

        set HA_Belief_Hunter-Alpha_Heading temp-heading
        set HA_Belief_Hunter-Alpha_Distance temp-distance
        set HA_Belief_Alpha-X temp-x
        set HA_Belief_Alpha-Y temp-y

        set HA_Belief_Hunter-Prey_Distance temp-distance
        set HA_Belief_Hunter-Prey_Heading temp-heading
        set HA_Belief_Prey-X temp-x
        set HA_Belief_Prey-Y temp-y
      ]
    ]
    set i i + 1
  ]
end
;;;;;;;;;;;;;;; Deliberation ;;;;;;;;;;;;;;;;

to HA_deliberate_lioness-alpha ; Alpha lioness main deliberation cycle
  HA_brf_cycle
  GA_deliberate_cycle

  if HA_Belief_Beta1-Seen = true [
    show "Deliberate - I See Beta1"
    set HA_Belief_Beta1-Known true
  ]

  if GA_Desire_Food = true [     ; this is the entry condition into the "Hunting Cycle"
    if (HA_Belief_Hunt-Mode = "Rest") [
      set HA_Belief_Hunt-Mode "I Search for Prey"
      show "I'm Searching For Prey"
    ]
  ]

 if HA_Belief_Hunt-Mode = "I Search for Prey" [
    if HA_Belief_Heard-Call = true [
      set HA_Belief_Hunt-Mode "Pack Found Prey"
      show "Pack Found Prey"
    ]

    if (HA_Belief_Prey-Seen = true) [
      set HA_Belief_Hunt-Mode "I See Prey"
      set HA_Belief_Prey-Known true
      show "I See Prey"
      if (HA_Belief_Heard-Call = false) [
        HA_irf_communicate-prey_found
      ]
    ]

    if (HA_Belief_Prey-Seen = false) and (HA_Belief_Prey-Known = true)[
      set HA_Belief_Hunt-Mode "I Search for Prey at Last Known Location"
    ]

    if (HA_Belief_Heard-Call = false) and (HA_Belief_Prey-Seen = false) [
;      show "I move to search for prey"
      HA_irf_search-prey
    ]
  ]

  if HA_Belief_Hunt-Mode = "Pack Found Prey" [
    HA_irf_move-alpha
    set HA_Belief_Hunt-Mode "I Search for Prey"
    show "Back to I Search For Prey"
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey at Last Known Location" [
    ifelse (HA_Belief_Prey-Seen = false) and (xcor = HA_Belief_Prey-X) and (ycor = HA_Belief_Prey-Y) [
      set HA_Belief_Prey-Known False
      show "At Last Known Prey Location"
    ][
      HA_irf_move-prey_fast
      show "Moving to Last Known Prey Location"
    ]
    set HA_Belief_Hunt-Mode "I Search for Prey"
  ]

  if HA_Belief_Hunt-Mode = "I See Prey" [
    HA_irf_communicate-prey_found
    if (HA_Belief_Hunter-Prey_Distance >= 16) [ HA_irf_move-prey_fast ]
    if (HA_Belief_Hunter-Prey_Distance < 16) [
      set HA_Belief_Hunt-Mode "Encircle"
      show "Move to Encircle"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Encircle" [
    HA_brf_lioness-spatial_update
    show [(word "Encircle-X - ("HA_Belief_Encircle-X") Encircle-Y - ("HA_Belief_Encircle-Y")"  )] of self
    if (HA_Belief_Encircle-X - HA_Belief_Beta1-X < 5) and (HA_Belief_Encircle-Y - HA_Belief_Beta1-Y < 5) [
      set HA_Belief_Hunt-Mode "Approach"
      show "I see Beta...Move to Approach"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Approach" [
    if (HA_Belief_Beta1-Seen = true) [
      if ((HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Hunter-Prey_Distance > 7)) [
        HA_irf_move-prey_normal-linear
      ]
      if (HA_Belief_Hunter-Prey_Distance < 9) [
        set HA_Belief_Hunt-Mode "Strike"
        show "Move to Strike"
      ]
    ]
  ]

  if HA_Belief_Hunt-Mode = "Strike" [
    HA_irf_move-prey_pounce
    set HA_Belief_Hunt-Mode "Move to Kill"
  ]

  if HA_Belief_Hunt-Mode = "Kill" [
    if HA_Belief_Prey-atSource = true [
      HA_irf_kill-prey
      set HA_Belief_Hunt-Mode "Move to Eat"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Eat" [
     HA_irf_eat-prey
    set HA_Belief_Hunt-Mode "Rest"
  ]

  if HA_Belief_Hunt-Mode = "Rest" [
    HA_brf_reset-beliefs
  ]

 show [(word "Alpha Hunt State - ("HA_Belief_Hunt-Mode")")] of self
 show [(word "Alpha Patch Colour - ("pcolor")")] of patch-here

end

to HA_deliberate_lioness-beta ; Beta lioness main deliberation cycle
  HA_brf_cycle
  GA_deliberate_cycle

  if HA_Belief_Alpha-Seen = true [
      show "Deliberate - I See Alpha"
      set HA_Belief_Alpha-Known true
  ]

  if GA_Desire_Food = true [     ; this is the entry condition into the "Hunting Cycle"
    if (HA_Belief_Hunt-Mode = "Rest") [
      set HA_Belief_Hunt-Mode "I Search for Prey"
      show "I'm Searching For Prey"
    ]
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey" [
    if HA_Belief_Heard-Call = true [
      set HA_Belief_Hunt-Mode "Pack Found Prey"
      show "Pack Found Prey"
    ]

    if (HA_Belief_Prey-Seen = true) [
      set HA_Belief_Hunt-Mode "I See Prey"
      set HA_Belief_Prey-Known true
      show "I See Prey"
      if (HA_Belief_Heard-Call = false) and (HA_Belief_Alpha-Seen = false) [
        HA_irf_communicate-prey_found
      ]
    ]

    if (HA_Belief_Prey-Seen = false) and (HA_Belief_Prey-Known = true)[
      set HA_Belief_Hunt-Mode "I Search for Prey at Last Known Location"
    ]

    if (HA_Belief_Heard-Call = false) and (HA_Belief_Prey-Seen = false) [
      HA_irf_search-prey
    ]
  ]

  if HA_Belief_Hunt-Mode = "Pack Found Prey" [
    HA_irf_move-alpha
    set HA_Belief_Hunt-Mode "I Search for Prey"
    show "Back to I Search For Prey"
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey at Last Known Location" [
    ifelse (HA_Belief_Prey-Seen = false) and (xcor = HA_Belief_Prey-X) and (ycor = HA_Belief_Prey-Y) [
      set HA_Belief_Prey-Known False
      show "At Last Known Prey Location"
    ][
      HA_irf_move-prey_fast
      show "Moving to Last Known Prey Location"
    ]
    set HA_Belief_Hunt-Mode "I Search for Prey"
  ]

  if HA_Belief_Hunt-Mode = "I See Prey" [
    if (HA_Belief_Hunter-Prey_Distance >= 16) [ HA_irf_move-prey_fast ]
    if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = true) [
      set HA_Belief_Hunt-Mode "Encircle"
      show "Move to Encircle"
    ]
   if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = false) [
     HA_irf_search-alpha
    ]
  ]

  if HA_Belief_Hunt-Mode = "Encircle" [
    HA_brf_lioness-spatial_update
    show [(word "Encircle-X - ("HA_Belief_Encircle-X") Encircle-Y - ("HA_Belief_Encircle-Y")"  )] of self
    HA_irf_move-encircle
    if (xcor = precision HA_Belief_Encircle-X 0) and (ycor =  precision HA_Belief_Encircle-Y 0) [
      HA_irf_face-prey
      set HA_Belief_Hunt-Mode "Approach"
      show "Move to Approach"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Approach" [
    if (HA_Belief_Prey-Seen = true) and (HA_Belief_Alpha-Known = true) [
      show "Approach - I see Prey and Alpha"
      HA_brf_lioness-spatial_update

 ;     if (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Alpha_Heading) <= 20 ) [ HA_irf_move-prey_normal-linear ]
      if HA_Belief_Beta1-Prey_Distance > (HA_Belief_Alpha-Prey_Distance - 1) [
          HA_irf_move-prey_normal-linear
      ]

      if HA_Belief_Beta1-Prey_Distance <= (HA_Belief_Alpha-Prey_Distance - 1) [
          ; wait until Alpha moves closer to Prey.
      ]

      if (HA_Belief_Hunter-Prey_Distance < 9) [
        set HA_Belief_Hunt-Mode "Strike"
        show "Move to Strike"
      ]
    ]
  ]

  if HA_Belief_Hunt-Mode = "Strike" [
    HA_irf_move-prey_pounce
    set HA_Belief_Hunt-Mode "Move to Kill"
  ]

 if HA_Belief_Hunt-Mode = "Kill" [
    if HA_Belief_Prey-atSource = true [
      HA_irf_kill-prey
      set HA_Belief_Hunt-Mode "Move to Eat"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Eat" [
     HA_irf_eat-prey
    set HA_Belief_Hunt-Mode "Rest"
  ]

  if HA_Belief_Hunt-Mode = "Rest" [
    HA_brf_reset-beliefs
  ]

  show [(word "Beta Hunt State - ("HA_Belief_Hunt-Mode")")] of self

end

to HA_deliberate_wolf-alpha  ; Alpha wolf main deliberation cycle
  HA_brf_cycle
  GA_deliberate_cycle

  if HA_Belief_Beta1-Seen = true [
    show "Deliberate - I See Beta1"
    set HA_Belief_Beta1-Known true
  ]

  if HA_Belief_Beta2-Seen = true [
      show "Deliberate - I See Beta2"
      set HA_Belief_Beta2-Known true
  ]

  if GA_Desire_Food = true [     ; this is the entry condition into the "Hunting Cycle"
    if (HA_Belief_Hunt-Mode = "Rest") [
      set HA_Belief_Hunt-Mode "I Search for Prey"
      show "I'm Searching For Prey"
    ]
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey" [
    if HA_Belief_Heard-Call = true [
      set HA_Belief_Hunt-Mode "Pack Found Prey"
      show "Pack Found Prey"
    ]

    if (HA_Belief_Prey-Seen = true) [
      set HA_Belief_Hunt-Mode "I See Prey"
      set HA_Belief_Prey-Known true
      show "I See Prey"
      if (HA_Belief_Heard-Call = false) [
        HA_irf_communicate-prey_found
      ]
    ]

    if (HA_Belief_Prey-Seen = false) and (HA_Belief_Prey-Known = true)[
      set HA_Belief_Hunt-Mode "I Search for Prey at Last Known Location"
    ]

    if (HA_Belief_Heard-Call = 0) and (HA_Belief_Prey-Seen = false) [
      show "I move to search for prey"
      HA_irf_search-prey
    ]
  ]

  if HA_Belief_Hunt-Mode = "Pack Found Prey" [
    HA_irf_move-alpha
    set HA_Belief_Hunt-Mode "I Search for Prey"
    show "Back to I Search For Prey"
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey at Last Known Location" [
    ifelse (HA_Belief_Prey-Seen = false) and (xcor = HA_Belief_Prey-X) and (ycor = HA_Belief_Prey-Y) [
      set HA_Belief_Prey-Known False
      show "At Last Known Prey Location"
    ][
      HA_irf_move-prey_fast
      show "Moving to Last Known Prey Location"
    ]
    set HA_Belief_Hunt-Mode "I Search for Prey"
  ]

  if HA_Belief_Hunt-Mode = "I See Prey" [
    HA_irf_communicate-prey_found
    if (HA_Belief_Hunter-Prey_Distance >= 16) [ HA_irf_move-prey_fast ]
    if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Beta1-Seen = true) and (HA_Belief_Beta2-Seen = true)[
      set HA_Belief_Hunt-Mode "Encircle"
      show "Move to Encircle"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Encircle" [
    HA_brf_wolf-spatial_update

    let beta1-dx abs(HA_Belief_Beta1-Encircle-X - HA_Belief_Beta1-X)
    let beta1-dy abs(HA_Belief_Beta1-Encircle-Y - HA_Belief_Beta1-Y)
    let beta2-dx abs(HA_Belief_Beta2-Encircle-X - HA_Belief_Beta2-X)
    let beta2-dy abs(HA_Belief_Beta2-Encircle-Y - HA_Belief_Beta2-Y)

show [(word "( Encircle1 - "HA_Belief_Beta1-X ", " HA_Belief_Beta1-Y ", "HA_Belief_Beta2-X ", "HA_Belief_Beta2-Y ")"  )] of self
show [(word "( Encircle2 - "HA_Belief_Beta1-Encircle-X ", "HA_Belief_Beta1-Encircle-Y ", "HA_Belief_Beta2-Encircle-X ", "HA_Belief_Beta2-Encircle-Y ")"  )] of self
show [(word "( Encircle3 - "beta1-dx ", " beta1-dy ", " beta2-dx ", " beta2-dy ")"  )] of self

    if (beta1-dx <= 8 ) and (beta1-dy <= 8 ) and (beta2-dx <= 8 ) and (beta2-dy <= 8 ) [
 ;   if (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Beta1_Heading) <= 20 ) and (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Beta2_Heading) <= 20 )[

        set HA_Belief_Hunt-Mode "Approach"
        show "Move to Approach"
      ]

    if HA_Belief_Prey-Seen = false [
        set HA_Belief_Hunt-Mode "I Search for Prey"
      ]
  ]

  if HA_Belief_Hunt-Mode = "Approach" [
    if (HA_Belief_Beta1-Seen = true) and (HA_Belief_Beta2-Seen = true) [
      show "I see Beta1 and Beta2" ]
      if ((HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Hunter-Prey_Distance > 7)) [
        HA_irf_move-prey_normal-linear ]
      if (HA_Belief_Hunter-Prey_Distance < 9) [
        set HA_Belief_Hunt-Mode "Strike"
        show "Move to Strike"
      ]
      if HA_Belief_Prey-Seen = false [
        set HA_Belief_Hunt-Mode "I Search for Prey"
      ]
    ]

  if HA_Belief_Hunt-Mode = "Strike" [
    HA_irf_move-prey_pounce
    set HA_Belief_Hunt-Mode "Move to Kill"
  ]

  if HA_Belief_Hunt-Mode = "Kill" [
    if HA_Belief_Prey-atSource = true [
      HA_irf_kill-prey
      set HA_Belief_Hunt-Mode "Move to Eat"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Eat" [
     HA_irf_eat-prey
     set HA_Belief_Hunt-Mode "Rest"
  ]

  if HA_Belief_Hunt-Mode = "Rest" [
    HA_brf_reset-beliefs
  ]

 show [(word "Alpha Hunt State - ("HA_Belief_Hunt-Mode")")] of self
 show [(word "Alpha Patch Colour - ("pcolor")")] of patch-here

end

to HA_deliberate_wolf-beta ; Beta wolf main deliberation cycle
  HA_brf_cycle
  GA_deliberate_cycle

  if HA_Belief_Alpha-Seen = true [
      show "Deliberate - I See Alpha"
      set HA_Belief_Alpha-Known true
;      if (abs(xcor - HA_Belief_Alpha-X) < 4) and (abs(ycor - HA_Belief_Alpha-Y) < 4) [
;        show "I'm next to Alpha"
;      ]
  ]

  if GA_Desire_Food = true [     ; this is the entry condition into the "Hunting Cycle"
    if (HA_Belief_Hunt-Mode = "Rest") [
      set HA_Belief_Hunt-Mode "I Search for Prey"
      show "I'm Searching For Prey"
    ]
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey" [
    if HA_Belief_Heard-Call = true [
      set HA_Belief_Hunt-Mode "Pack Found Prey"
      show "Pack Found Prey"
    ]

    if (HA_Belief_Prey-Seen = true) [
      set HA_Belief_Hunt-Mode "I See Prey"
      set HA_Belief_Prey-Known true
      show "I See Prey"
      if (HA_Belief_Heard-Call = false) and (HA_Belief_Alpha-Seen = false) [
        HA_irf_communicate-prey_found
      ]
    ]

    if (HA_Belief_Prey-Seen = false) and (HA_Belief_Prey-Known = true)[
      set HA_Belief_Hunt-Mode "I Search for Prey at Last Known Location"
    ]

    if (HA_Belief_Heard-Call = 0) and (HA_Belief_Prey-Seen = false) [
      show "I move to search for prey"
      HA_irf_search-prey
    ]
  ]

  if HA_Belief_Hunt-Mode = "Pack Found Prey" [
    HA_irf_move-alpha
    set HA_Belief_Hunt-Mode "I Search for Prey"
    show "Back to I Search For Prey"
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey at Last Known Location" [
;    if (HA_Belief_Prey-Seen = true) [
;      set HA_Belief_Hunt-Mode "I See Prey"
;      set HA_Belief_Prey-Known true
;      show "Last Known Location - I See Prey"
;    ]
    ifelse (HA_Belief_Prey-Seen = false) and (xcor = HA_Belief_Prey-X) and (ycor = HA_Belief_Prey-Y) [
      set HA_Belief_Prey-Known False
      show "At Last Known Prey Location"
    ][
      HA_irf_move-prey_fast
      show "Moving to Last Known Prey Location"
    ]
    set HA_Belief_Hunt-Mode "I Search for Prey"
  ]

  if HA_Belief_Hunt-Mode = "I See Prey" [
    if (HA_Belief_Hunter-Prey_Distance >= 16) [ HA_irf_move-prey_fast ]
    if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = true) [
      set HA_Belief_Hunt-Mode "Encircle"
      show "Move to Encircle"
    ]
   if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = false) [
     HA_irf_search-alpha
    ]
  ]

  if HA_Belief_Hunt-Mode = "Encircle" [
    HA_brf_wolf-spatial_update
    show [(word "Encircle-X - ("HA_Belief_Encircle-X") Encircle-Y - ("HA_Belief_Encircle-Y")"  )] of self
    HA_irf_move-encircle
    if (xcor = precision HA_Belief_Encircle-X 0) and (ycor =  precision HA_Belief_Encircle-Y 0) [
      HA_irf_face-prey
      set HA_Belief_Hunt-Mode "Approach"
      show "Move to Approach"
    ]
  ]

;  if HA_Belief_Hunt-Mode = "Approach" [
 ;   if (HA_Belief_Prey-Seen = true) and (HA_Belief_Alpha-Known = true) [
 ;     show "Approach - I see Prey and Alpha"
 ;     HA_brf_wolf-spatial_update
 ;     HA_irf_move-prey_normal-linear

;      if label = "Beta1" [
;        if HA_Belief_Beta1-Prey_Distance > (HA_Belief_Alpha-Prey_Distance - 5) [
;          HA_irf_move-prey_normal-linear
;        ]
;
;        if HA_Belief_Beta1-Prey_Distance <= (HA_Belief_Alpha-Prey_Distance - 5) [
;          ; wait until Alpha moves closer to Prey.
;        ]

;      ]

 ;     if label = "Beta2" [
  ;      if HA_Belief_Beta2-Prey_Distance > (HA_Belief_Alpha-Prey_Distance - 5) [
   ;       HA_irf_move-prey_normal-linear
    ;    ]
;
 ;       if HA_Belief_Beta2-Prey_Distance < (HA_Belief_Alpha-Prey_Distance - 5) [
  ;        ; wait until Alpha moves closer to Prey.
   ;     ]
    ;  ]

;      if (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Alpha_Heading) <= 20 ) [ HA_irf_move-prey_normal-linear ]
;      if (HA_Belief_Hunter-Prey_Distance < 9) [
;        set HA_Belief_Hunt-Mode "Strike"
;        show "Move to strike"
;      ]
;    ]
;  ]

  if HA_Belief_Hunt-Mode = "Approach" [
    if (HA_Belief_Prey-Seen = true) and (HA_Belief_Alpha-Known = true) [
      show "Approach - I see Prey and Alpha"
      HA_brf_wolf-spatial_update
      if (HA_Belief_Hunter-Prey_Distance > (HA_Belief_Alpha-Prey_Distance)) [
        HA_irf_move-prey_normal-linear
      ]
    ]

;      if (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Alpha_Heading) <= 20 ) [ HA_irf_move-prey_normal-linear ]


    if (HA_Belief_Hunter-Prey_Distance < 9) and (HA_Belief_Alpha-Prey_Attack = true) [
      set HA_Belief_Hunt-Mode "Strike"
      show "Move to strike"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Strike" [
    HA_irf_move-prey_pounce
    set HA_Belief_Hunt-Mode "Move to Kill"
  ]

  if HA_Belief_Hunt-Mode = "Kill" [
    if HA_Belief_Prey-atSource = true [
      HA_irf_kill-prey
      set HA_Belief_Hunt-Mode "Move to Eat"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Eat" [
    HA_irf_eat-prey
    set HA_Belief_Hunt-Mode "Rest"
  ]

  if HA_Belief_Hunt-Mode = "Rest" [
    HA_brf_reset-beliefs
  ]

  show [(word "Beta Hunt State - ("HA_Belief_Hunt-Mode")")] of self

end

to HA_deliberate_wolf-omega ; Omega wolf main deliberation cycle
  HA_brf_cycle
  GA_deliberate_cycle

  if HA_Belief_Alpha-Seen = true [
      show "Deliberate - I See Alpha"
      set HA_Belief_Alpha-Known true
  ]

  if HA_Belief_Beta1-Seen = true [
    show "Deliberate - I See Beta1"
    set HA_Belief_Beta1-Known true
  ]

  if HA_Belief_Beta2-Seen = true [
      show "Deliberate - I See Beta2"
      set HA_Belief_Beta2-Known true
  ]

  if GA_Desire_Food = true [     ; this is the entry condition into the "Hunting Cycle"
    if (HA_Belief_Hunt-Mode = "Rest") [
      set HA_Belief_Hunt-Mode "I Search for Prey"
      show "I'm Searching For Prey"
    ]
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey" [

    if HA_Belief_Heard-Call = true [
      set HA_Belief_Hunt-Mode "Pack Found Prey"
      show "Pack Found Prey"
    ]

    if (HA_Belief_Prey-Seen = true) [
      set HA_Belief_Hunt-Mode "I See Prey"
      set HA_Belief_Prey-Known true
      show "I See Prey"
      if (HA_Belief_Heard-Call = false) and (HA_Belief_Alpha-Seen = false) [
        HA_irf_communicate-prey_found
      ]
    ]

    if (HA_Belief_Prey-Seen = false) and (HA_Belief_Prey-Known = true)[
      set HA_Belief_Hunt-Mode "I Search for Prey at Last Known Location"
    ]

;    show [(word "Heard-Call - ("HA_Belief_Heard-Call") Seen-Prey - ("HA_Belief_Prey-Seen")"  )] of self

    if (HA_Belief_Heard-Call = 0) and (HA_Belief_Prey-Seen = false) [
      show "I move to search for prey"
      HA_irf_search-prey
    ]
  ]

  if HA_Belief_Hunt-Mode = "Pack Found Prey" [
    HA_irf_move-alpha
    set HA_Belief_Hunt-Mode "I Search for Prey"
    show "Back to I Search For Prey"
  ]

  if HA_Belief_Hunt-Mode = "I Search for Prey at Last Known Location" [
    ifelse (HA_Belief_Prey-Seen = false) and (xcor = HA_Belief_Prey-X) and (ycor = HA_Belief_Prey-Y) [
      set HA_Belief_Prey-Known False
      show "At Last Known Prey Location"
    ][
      HA_irf_move-prey_fast
      show "Moving to Last Known Prey Location"
    ]
    set HA_Belief_Hunt-Mode "I Search for Prey"
  ]

  if HA_Belief_Hunt-Mode = "I See Prey" [
    if (HA_Belief_Hunter-Prey_Distance >= 16) [ HA_irf_move-prey_fast ]
    if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = true) [
      set HA_Belief_Hunt-Mode "Encircle"
      show "Move to Encircle"
    ]
   if (HA_Belief_Hunter-Prey_Distance < 16) and (HA_Belief_Alpha-Known = false) [
     HA_irf_search-alpha
    ]
  ]

  if HA_Belief_Hunt-Mode = "Encircle" [
    HA_brf_wolf-spatial_update
;    show [(word "Encircle-X - ("HA_Belief_Encircle-X") Encircle-Y - ("HA_Belief_Encircle-Y")"  )] of self
    HA_irf_move-encircle
    if (xcor = precision HA_Belief_Encircle-X 0) and (ycor =  precision HA_Belief_Encircle-Y 0) [
;      HA_irf_face-prey
      set HA_Belief_Hunt-Mode "Approach"
      show "Move to Approach"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Approach" [
;    if (HA_Belief_Hunter-Beta1_Distance < 7) or (HA_Belief_Hunter-Beta2_Distance < 7) [
;       HA_irf_face-prey
;    ]
;    if (HA_Belief_Prey-Seen = true) and (HA_Belief_Alpha-Known = true) [
;      show "Approach - I see Prey and Alpha"
;      HA_brf_wolf-spatial_update
;      HA_irf_move-prey_normal-linear
;    ]

;      if (abs(HA_Belief_Hunter-Prey_Heading - HA_Belief_Hunter-Alpha_Heading) <= 20 ) [ HA_irf_move-prey_normal-linear ]

    HA_irf_face-prey

    if (HA_Belief_Prey-Seen = true) and (HA_Belief_Alpha-Known = true) [
      if (HA_Belief_Hunter-Prey_Distance >= 9) [
        HA_irf_move-prey_normal-linear
      ]

      if (HA_Belief_Hunter-Prey_Distance < 9) and (HA_Belief_Alpha-Prey_Attack = true) [
        set HA_Belief_Hunt-Mode "Strike"
        show "Move to strike"
      ]
    ]
  ]

  if HA_Belief_Hunt-Mode = "Strike" [
    HA_irf_move-prey_pounce
    set HA_Belief_Hunt-Mode "Move to Kill"
  ]

 if HA_Belief_Hunt-Mode = "Kill" [
    if HA_Belief_Prey-atSource = true [
      HA_irf_kill-prey
      set HA_Belief_Hunt-Mode "Move to Eat"
    ]
  ]

  if HA_Belief_Hunt-Mode = "Eat" [
    HA_irf_eat-prey
    set HA_Belief_Hunt-Mode "Rest"
  ]

  if HA_Belief_Hunt-Mode = "Rest" [
    HA_brf_reset-beliefs
  ]

  show [(word "Omega Hunt State - ("HA_Belief_Hunt-Mode")")] of self
end

;;;;;;;;;;;;; Desire Review Function (DRF) ;;;;;;;;;;;;;;;;

; the HAs for desire was food controlled at instantiation...this desire remains to be developed
to HA_drf_desire

end

;;;;;;;;;;;;;; Intention Review Function (IRF) ;;;;;;;;;;;;

to HA_irf_communicate-prey_found ; HA intends to make a sound indicating that it has observed a PA
  HA_action_talk-prey_found

end

to HA_irf_eat-prey ; HA intends to eat PA
  HA_action_eat-prey
end

to HA_irf_face-prey ; HA intends to face PA
  HA_action_face-prey
end

to HA_irf_kill-prey ; HA intends to kill PA
  HA_action_kill-prey
end

to HA_irf_move-alpha ; HA intends to move towards Alpha HA
  HA_action_move-alpha
  HA_action_face-alpha_heading
end

to HA_irf_move-encircle ; HA intends to move to encircle PA
  HA_action_move-encircle
end

to HA_irf_move-prey_fast ; HA intends to move fast towards PA
 HA_action_move-prey_fast
end

to HA_irf_move-prey_normal-linear ; HA intends to move linearly towards PA
  HA_action_move-prey_normal
end

to HA_irf_move-prey_pounce ; HA intends to pounce on HA
  HA_action_move-prey_pounce
end

to HA_irf_search-alpha ; HA intends to search for Alpha HA
  HA_action-search-alpha
end

to HA_irf_search-prey ; HA intends to search for PA
  HA_action_search-prey
end

;;;;;;;;;;;;;; Perceptions ;;;;;;;;;;

;  HA_Perceive_Visual-Scan            Perception: this is a list of perceived objects during a visual scan.
;  HA_Perceive-Scent-Scan             Perception: this is a list of scents on the patches immediately surrounding the Hunter Agent.

to HA_perception_scent-scan_atSource ; HA scans for scent on the patch that it occupies
  set HA_Perceive-Scents []

  ask patch-here [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

end

to HA_perception_scent-scan_box ; HA scans for scent on the patches adjacent to it...simulates the HA turning in a circle to smell the ground around it.
  set HA_Perceive-Scents []

  ask patch-ahead 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 45 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 90 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 135 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 180 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 225 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 270 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

  ask patch-right-and-ahead 315 1 [
    let m []
    set m lput WA_Patch_State_Scent-Type m
    set m lput WA_Patch_State_Scent-Level m
    ask myself [set HA_Perceive-Scents lput m HA_Perceive-Scents]
  ]

end

to HA_perception_sound ; HA scans for sound on the patch it occupies
  set HA_Perceive-Sounds []
  let sender 0
  let name "name"
  let sound-x 0
  let sound-y 0
  let sound-level 0
  let message "HA_perception_sound-message"
  let n []

  ask patch-here [
    foreach WA_Patch_State_Sounds [ [m] ->
      set sender (item 0 m)
      set name (item 1 m)
      set sound-x (item 2 m)
      set sound-y (item 3 m)
      set sound-level (item 4 m)
      set message (item 5 m)

      set n []
      if sound-level >= 1 [
        set n lput sender n
        set n lput name n
        set n lput sound-x n
        set n lput sound-y n
        set n lput sound-level n
        set n lput message n

        ask myself [set HA_Perceive-Sounds lput n HA_Perceive-Sounds]
      ]
    ]
  ]
;  show "HA_perception_sound" ; [(word "brf_sounds - ("message")")] of self

end

to HA_perception_visual-scan ; HA visually scans the WA

  set GA_Perceive_Visual-Scan []

;;;;; Scan Agent's Patch;;;;;

  ask patch-here [ ; determines the patch that the Agent is standing on
    let m []
    set m lput pcolor m
    set m lput 0 m
    set m lput 0 m
    set m lput pxcor m
    set m lput pycor m
    set m lput WA_Patch_State_Agent-Number m
    set m lput WA_Patch_State_Agent-Heading m
    set m lput WA_Patch_State_Agent-Speed m
    ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
  ]

;;;;; Center Scan;;;;;

  set GA_State_Scan-Distance 1

  let i GA_State_Scan-Distance

  while [i <= 40] [
    ask patch-ahead i [ ; determines the patches in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

;;;;; Left Scan;;;;;

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 2.5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 7.5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 10 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 12.5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
     ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 15 i [ ; determines the patches left by 15 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 17.5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 20 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 22.5 i [ ; determines the patches left by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-left-and-ahead 25 i [ ; determines the patches left by 25 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 35] [
    ask patch-left-and-ahead 30 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 36) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 30] [
    ask patch-left-and-ahead 35 i [ ; determines the patches left by 35 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 31) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 25] [
    ask patch-left-and-ahead 40 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 26) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 25] [
    ask patch-left-and-ahead 45 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 26) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 20] [
    ask patch-left-and-ahead 55 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 20] [
    ask patch-left-and-ahead 65 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 20] [
    ask patch-left-and-ahead 75 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 20] [
    ask patch-left-and-ahead 85 i [ ; determines the patches left by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

;;;;; Right Scan;;;;;

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 2.5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 7.5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 10 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 12.5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
   ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 15 i [ ; determines the patches right by 15 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 17.5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 20 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 22.5 i [ ; determines the patches right by 5 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 40] [
    ask patch-right-and-ahead 25 i [ ; determines the patches right by 25 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 41) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 35] [
    ask patch-right-and-ahead 30 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 36) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 30] [
    ask patch-right-and-ahead 35 i [ ; determines the patches right by 35 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 31) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 25] [
    ask patch-right-and-ahead 40 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 26) ]
    ]
    set i (i + 1)
  ]

  set i 1

  while [i <= 25] [
    ask patch-right-and-ahead 45 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 26) ]
    ]
    set i (i + 1)
  ]

 set i 1

  while [i <= 20] [
    ask patch-right-and-ahead 55 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

 set i 1

  while [i <= 20] [
    ask patch-right-and-ahead 65 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
     if ((pcolor = green) or (pcolor = grey)) [ (set i 21) ]
    ]
    set i (i + 1)
  ]

 set i 1

 while [i <= 20] [
    ask patch-right-and-ahead 75 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 25) ]
    ]
    set i (i + 1)
  ]

 set i 1

  while [i <= 20] [
    ask patch-right-and-ahead 85 i [ ; determines the patches right by 45 degrees in front of the Agent
      let h (remainder int ((towards myself) + 180) 360)
      let m []
      set m lput pcolor m
      set m lput h m
      set m lput i m
      set m lput pxcor m
      set m lput pycor m
      set m lput WA_Patch_State_Agent-Number m
      set m lput WA_Patch_State_Agent-Heading m
      set m lput WA_Patch_State_Agent-Speed m
      ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
      if ((pcolor = green) or (pcolor = grey)) [ (set i 25) ]
    ]
    set i (i + 1)
  ]
end

;;;;;The following code was an unsuccessful attempt to simplify the visual perception using a sub-procedure;;;;;;;;;;;;;;;;
 ;set GA_State_Scan-Distance 1

 ; while [GA_State_Scan-Distance <= 20] [
 ;   ask patch-right-and-ahead 85 GA_State_Scan-Distance [ ; determines the patches right by 45 degrees in front of the Agent
 ;     HA_perception_visual-scan_subcode
 ;  ]
 ;   set GA_State_Scan-Distance (GA_State_Scan-Distance + 1)
;  ]
;end

;to HA_perception_visual-scan_subcode
;  let h (remainder int ((towards myself) + 180) 360)
;  let m []
;  set m lput pcolor m
;  set m lput h m
; set m lput GA_State_Scan-Distance m
;  set m lput pxcor m
 ; set m lput pycor m
;  set m lput WA_Patch_State_Agent-Number m
;  set m lput WA_Patch_State_Agent-Heading m
;  set m lput WA_Patch_State_Agent-Speed m
;  ask myself [set GA_Perceive_Visual-Scan lput m GA_Perceive_Visual-Scan]
;  if ((pcolor = green) or (pcolor = grey)) [ (set GA_State_Scan-Distance 25) ]
;end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;END OF HAPEE;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@#$#@#$#@
GRAPHICS-WINDOW
536
10
1129
604
-1
-1
2.9130435
1
10
1
1
1
0
1
1
1
-100
100
-100
100
1
1
1
ticks
15.0

BUTTON
378
301
441
334
go
WA_deliberate_cycle
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
286
596
396
629
#Level3Hunters
#Level3Hunters
0
6
1.0
1
1
NIL
HORIZONTAL

BUTTON
34
303
114
336
Setup / Reset
WA_deliberate_setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
291
301
372
334
go once
WA_deliberate_cycle
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
64
280
193
298
Model Setup (Deliberation)
11
0.0
0

TEXTBOX
306
280
439
298
Execution (Deliberation)
11
0.0
0

TEXTBOX
127
10
385
38
ENVIRONMENTAL SETUP OPTIONS (PERCEPTIONS)
11
0.0
0

MONITOR
137
344
199
389
Tick-Count
ticks
0
1
11

SLIDER
285
557
397
590
#Level2Hunters
#Level2Hunters
0
2
2.0
1
1
NIL
HORIZONTAL

SLIDER
285
518
395
551
#Level1Hunters
#Level1Hunters
0
2
1.0
1
1
NIL
HORIZONTAL

SLIDER
6
95
136
128
Vegetation-Density
Vegetation-Density
0
25
4.0
1
1
NIL
HORIZONTAL

SLIDER
6
133
119
166
Rock-Density
Rock-Density
0
15
0.0
1
1
NIL
HORIZONTAL

SLIDER
6
171
110
204
Water-Density
Water-Density
0
15
0.0
1
1
NIL
HORIZONTAL

SLIDER
86
463
178
496
Prey-Adult
Prey-Adult
0
100
1.0
1
1
NIL
HORIZONTAL

SLIDER
86
501
201
534
Prey-Adolescent
Prey-Adolescent
0
100
1.0
1
1
NIL
HORIZONTAL

SLIDER
6
209
117
242
Marsh-Density
Marsh-Density
0
100
0.0
1
1
NIL
HORIZONTAL

BUTTON
142
96
239
129
Setup-Vegetation
WA_perception_setup-vegetation
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
192
171
260
204
Setup-River
WA_perception_setup-river
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
116
171
188
204
Setup-Water
WA_perception_setup-water
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
123
210
196
243
Setup-Marsh
WA_perception_setup-marsh
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
126
133
239
166
Setup-Rock Features
WA_perception_setup-rock_features
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
86
540
182
573
Prey-Setup
WA_perception_prey-setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
276
113
383
146
Wind-Strength
Wind-Strength
0
10
10.0
1
1
NIL
HORIZONTAL

BUTTON
276
153
343
186
Setup-Wind
NIL
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
393
62
511
95
Rain-Frequency
Rain-Frequency
0
100
99.0
1
1
NIL
HORIZONTAL

SLIDER
393
113
497
146
Rain-Intensity
Rain-Intensity
0
10
10.0
1
1
NIL
HORIZONTAL

BUTTON
393
153
464
186
Setup-Rain
NIL
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
277
62
369
107
Wind-Direction
Wind-Direction
"Random" "North" "North-East" "East" "South-East" "South" "South-West" "West" "North-West"
0

BUTTON
86
578
175
611
Prey Clear
WA_perception_prey-clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
122
303
227
336
Reset Tick Counter
WA_deliberate_clear-ticks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
49
346
104
379
Clear
WA_deliberate_clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
91
446
241
464
Prey Agent (PA)
11
0.0
1

TEXTBOX
306
444
401
462
Hunter Agent (HA)
11
0.0
1

BUTTON
404
518
516
551
Hunters-Setup
WA_perception_hunters-setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
404
558
517
591
Hunters-Clear
WA_perception_hunters-clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
96
34
136
52
Terrain
11
0.0
1

TEXTBOX
375
33
420
51
Weather
11
0.0
1

SLIDER
6
57
114
90
Food-Density
Food-Density
0
20
0.0
1
1
NIL
HORIZONTAL

BUTTON
120
57
195
90
Setup-Food
WA_perception_setup-food
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
141
257
364
275
WORLD AGENT CONTROLS (DELIBERATIONS)
11
0.0
1

CHOOSER
276
198
414
243
Terrain-Type
Terrain-Type
"Savanna" "Forest" "Tundra"
0

TEXTBOX
149
415
345
443
AGENT SETUP OPTIONS (PERCEPTIONS)
11
0.0
1

CHOOSER
285
466
395
511
Hunter-Type
Hunter-Type
"Wolves" "Lionesses"
1

SWITCH
405
467
524
500
Algorithm-Test
Algorithm-Test
0
1
-1000

@#$#@#$#@
## -----------------------------------------------------------------------------------------------------
## ---HUNTING ALGORITHM PERFORMANCE EVALUATION ENVIRONMENT---
## ------------------------------------------HAPEE---------------------------------------------------
## -------------------------------------------------------------------------------------------------------
##        A MAS HUNTING MODEL DEVELOPMENT ENVIRONMENT

For a detailed description of the model, please consult the attached thesis paper. 

## WHAT IS IT?

This model provides a MAS framework, structured on the Belief, Desire, and Intent (BDI) architecture, to evaluate hunting algorithms. While the environment was originally designed to evaluate the Lion Optimization Algorithm (LOA) and the Grey Wolf Optimization (GWO) algorithm, the hunting development environment can be easily adapted to evaluate algorithms for searching, hunting, and evasion. 

## HOW IT WORKS

The HAPEE consists of five (5) Agent types: World Agent (WA), Patch Agent, Generic Agent (GA), Prey Agent (PA), and Hunting Agent (HA). 

The World Agent and Patch Agent are simply the base NetLogo environment structured into the BDI architecture.

The Generic Agent offers a method to reuse code between the various types of Prey Agents and Hunting Agents.

The Prey Agent represents a deer (or gazelle) which is enabled with simple search algorithms to find food and water sources (stationary targets of fruit trees and streams) and evade predators.  

The Huning Agent represents lionesses (or wolves) which are enabled with pack cooperation and hunting algorithms to converge on relatively mobile prey.

With minimal re-programming, these agents can be re-designed to represent other creatures within the Animal Kingdom (with their respective search, hunt and evasion techniques).

## HOW TO USE IT

A key factor in search, hunt, and evasion algorithms is the presence of obstacles. The WA brokers the settings at the "interface" with the values set in the terrain parameters (subgroup of the environmental setup options) and, treating these as perceptions, instantiates these as obstacles within the hunting environment. The densities of food, water, foliage, and rocks are set as percentages of the total patches. Inactive, the weather and terrain types remain to be developed.

Also brokered as perceptions through the WA, the PA and HA parameters are set next and these establish the type, class, and quantity of prey and hunters.

The WA then brokers deliberations through the interface with the "Go Once", "Go", "Setup/Reset", and "Clear".  

During instantiation, the WA first establishes the terrain layout based on the probability density of the features establihsed in the interface. The stream can be enabled/disabled within the code itself. Next to be instantiated are the PAs and HAs. These can be placed in specific patterns/locations or can be randomly distributed (again hardcoded).

Clicking the "Go Once" or "Go" will drive one (or many) deliberation cycles within the WA, which then cascades to driving the deliberation cycles of the PAs and HAs.

The effectiveness of the hunting algorithms can be observed as the degree of convergence in time (ie. ticks) of the HAs onto the PAs (or the PAs onto the fruit trees).  

## EXTENDING THE MODEL

The model can be customized to include more agents (and types of agents), obstacles (terrain types), and search, hunt, and evasion algorithms.

## HOW TO CITE

If you mention this model, thesis paper, or the NetLogo software in a publication, we ask that you include the citations below. Use of any the diagrams from the thesis paper is authorized with appropriate citation (no need to seek additional permission from the author).

For the model itself:

* Prince, M. (2017).  MAS Modelling Environment for Hunting and Evasion Algorithms.  Athabasca University: Faculty of Science and Techology: School of Computing and Information Systems, Athabasca, Alberta, Canada.

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## NETLOGO COPYRIGHT AND LICENSE

Copyright 1999 Uri Wilensky.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

boat
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 33 230 157 182 150 169 151 157 156
Polygon -7500403 true true 149 55 88 143 103 139 111 136 117 139 126 145 130 147 139 147 146 146 149 55

boat 2
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 157 54 175 79 174 96 185 102 178 112 194 124 196 131 190 139 192 146 211 151 216 154 157 154
Polygon -7500403 true true 150 74 146 91 139 99 143 114 141 123 137 126 131 129 132 139 142 136 126 142 119 147 148 147

boat 3
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 37 172 45 188 59 202 79 217 109 220 130 218 147 204 156 158 156 161 142 170 123 170 102 169 88 165 62
Polygon -7500403 true true 149 66 142 78 139 96 141 111 146 139 148 147 110 147 113 131 118 106 126 71

boat top
true
0
Polygon -7500403 true true 150 1 137 18 123 46 110 87 102 150 106 208 114 258 123 286 175 287 183 258 193 209 198 150 191 87 178 46 163 17
Rectangle -16777216 false false 129 92 170 178
Rectangle -16777216 false false 120 63 180 93
Rectangle -7500403 true true 133 89 165 165
Polygon -11221820 true false 150 60 105 105 150 90 195 105
Polygon -16777216 false false 150 60 105 105 150 90 195 105
Rectangle -16777216 false false 135 178 165 262
Polygon -16777216 false false 134 262 144 286 158 286 166 262
Line -16777216 false 129 149 171 149
Line -16777216 false 166 262 188 252
Line -16777216 false 134 262 112 252
Line -16777216 false 150 2 149 62

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sailboat side
false
0
Line -16777216 false 0 240 120 210
Polygon -7500403 true true 0 239 270 254 270 269 240 284 225 299 60 299 15 254
Polygon -1 true false 15 240 30 195 75 120 105 90 105 225
Polygon -1 true false 135 75 165 180 150 240 255 240 285 225 255 150 210 105
Line -16777216 false 105 90 120 60
Line -16777216 false 120 45 120 240
Line -16777216 false 150 240 120 240
Line -16777216 false 135 75 120 60
Polygon -7500403 true true 120 60 75 45 120 30
Polygon -16777216 false false 105 90 75 120 30 195 15 240 105 225
Polygon -16777216 false false 135 75 165 180 150 240 255 240 285 225 255 150 210 105
Polygon -16777216 false false 0 239 60 299 225 299 240 284 270 269 270 254

shark
false
0
Polygon -7500403 true true 283 153 288 149 271 146 301 145 300 138 247 119 190 107 104 117 54 133 39 134 10 99 9 112 19 142 9 175 10 185 40 158 69 154 64 164 80 161 86 156 132 160 209 164
Polygon -7500403 true true 199 161 152 166 137 164 169 154
Polygon -7500403 true true 188 108 172 83 160 74 156 76 159 97 153 112
Circle -16777216 true false 256 129 12
Line -16777216 false 222 134 222 150
Line -16777216 false 217 134 217 150
Line -16777216 false 212 134 212 150
Polygon -7500403 true true 78 125 62 118 63 130
Polygon -7500403 true true 121 157 105 161 101 156 106 152

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0
@#$#@#$#@
setup 6
repeat 175 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
