;;; lorenz.nlogo rev 05, 10 july 2005 by ralph abraham
;;; based upon lorenz04.nlogo
;;; this is a 3D model in NetLogo 3-D pre 1
;;; NOTE: manually set screen-edge-x,y,z in 2D Graphic Window
;;; to 50 was too much, so try 17
;;; also useful to click "2D also" OFF in 3D window
;;; fix on 25 july 2005: set shape3d "sphere"
;;; rev 05: add speed slider, zhome button, add movie script button for movie #1
breed [ particles ]
breed [ drops ]
breed [ titleposts ]


globals
[
  labeltext1 labeltext2  ;;; for titles
  deltax deltay deltaz  ;;; window widths for conversion routines
  deltau deltav deltaw  ;;; world coord window widths
  umin umax vmin vmax wmin wmax ;;; from def of map-u and map-v
  xmin xmax ymin ymax zmin zmax ;;; from Graphics Window attributes
  totaltime             ;;; keep track of totaltime
  vpradius              ;;; to locate viewpoint
  vpangle
  ;;; c defined by a slider from 0 to 5
  ;;; stepsize ditto from 0 to 0.1
  ;;; dropcolor defined by a chooser
]

;;; procedures for runs

to title0
  set labeltext1 "MOVIE #0"
  set labeltext2 "The Axes"
  title
  wait 2
  titlezoom
  wait 2
end

to title1
  set labeltext1 "MOVIE #1"
  set labeltext2 "The Lorenz Attractor"
  title
  wait 2
  titlezoom
  wait 2
end

to title2
  set labeltext1 "MOVIE #2"
  set labeltext2 "Sensitive Dependence"
  title
  wait 2
  titlezoom
  wait 2
end

to movie#0
  setup ;;; includes clear-all, init-globals, place particle
  title0 ;;; title
  setxyz 0 0 25
  ask turtle 0 [ setxyz 0 0 0 ] ;;; mark origin
  crt 3 ;;; mark three axes
    ask turtle 1
    [
    set label "X"
    set size 3
    set color red
    setxyz 15 0 0
    ]
    ask turtle 2
    [
    set label "Y"
    set size 3
    setxyz 0 15 0
    set color blue
    ]
  ask turtle 3
    [
    set label "Z"
    set size 3
    set color yellow
    setxyz 0 0 15
    ]
  repeat 360 [ revolveXY ] ;;; 1/4 rotationXY
  wait 2
  repeat 360 [ revolveXZ ] ;;; full rotationXZ
end

to movie#1
  setup ;;; includes clear-all, init-globals, place particle
  title1 ;;; title test 1 , 2, zoom
  zhome  ;;; return observer to home
  repeat 10 [ go ]   ;;; should stop after 10 go's of 12 colors, step100's (100 steps) or 12,000 steps
  repeat 90 [ revolveXZ ] ;;; 1/4 full rotation
  zoom-in
  repeat 10 [ go ]
end

to movie#2
  setup ;;; includes clear-all, init-globals, place particle
  title2 ;;; title test 1 , 2, zoom
  zhome  ;;; return observer to home
  ask turtle 0 [ setxyz 5.1 7.2 -4.2 ]
  place-particle 5.1 7.2 -4.3
  ask turtle 2 [ set color blue ]
  repeat 1000 [
    wait sleeptime
    turnXY
    step ]
end

to movie#3

end

to init-globals
  set totaltime 0
  set xmin min-pxcor
  set xmax max-pxcor
  set ymin min-pycor
  set ymax max-pycor
  set zmin min-pzcor
  set zmax max-pzcor
  set deltax world-width - 1 ;;; this is Graphics Window attribute
  set deltay world-height - 1 ;;; this is Graphics Window attribute
  set deltaz world-depth - 1 ;;; this is Graphics Window attribute
  set umin -50
  set umax 50
  set vmin -50
  set vmax 50
  set wmin 0
  set wmax 100
  set deltau (umax - umin)
  set deltav (vmax - vmin)
  set deltaw (wmax - wmin)
  set vpradius 50
  set vpangle 0
end

;;; more procedures
to setup
  ca
  init-globals
  place-particle 10 10 25
end

;;; green test particles move along trajectories, leaving drops

to step
  ask particles
  [
    hatch-drops 1 [
      set shape "circle"
      set color dropcolor
      set size 0.5
    ]
    let xtemp xcor
    let ytemp ycor
    let ztemp zcor
    set xcor map-x xtemp ytemp ztemp ;;; move to image point
    set ycor map-y xtemp ytemp ztemp
    set zcor map-z xtemp ytemp ztemp
  ]
  set totaltime  ( totaltime + stepsize )
end

to step100
  repeat 100 [ step ]
end

to go  ;;; 1200 steps
  foreach [15 25 35 45 55 65 75 85 95 105 115 125]
    [ set dropcolor ?
      step100
    ]
end

;; create a particle at (x,y,z)
to place-particle [x y z]
  create-particles 1
  [
    set xcor x
    set ycor y
    set zcor z
    set shape "circle"
    set size 3
    set heading 0
    set color green
  ]
end

to revolveXY
  wait sleeptime
  turnXY
end

to turnXY
  let delta 1 ;;; one degree increment
  set vpangle ( vpangle - delta ) ;;; minus rotates right hand rule, thumb up
  setxyz ( vpradius * ( cos vpangle )) (vpradius * ( sin vpangle )) 0 ;;; circle in XY plane
  face patch 0 0 0
end

to revolveXZ
  wait sleeptime
  turnXZ
end

to turnXZ
  let delta 1 ;;; one degree increment
  set vpangle ( vpangle - delta ) ;;; minus rotates right hand rule, thumb up
  setxyz ( vpradius * ( cos vpangle )) 0 (vpradius * ( sin vpangle )) ;;; circle in XZ plane
  face patch 0 0 0
end

;;; reset pcolor of all patches
to clear
  ask drops
  [
    set color gray
  ]
end

to xhome
  setxyz 50 0 0
  face patch 0 0 0
end

to zhome
  setxyz 0 0 50
  face patch 0 0 0
end

to zoom-in
  zhome
  let t 0
  while [ t < 75 ]
    [
    wait 0.1  ;;; speed of zoom, this is medium
    setxyz 0 0 ( 50 - t )
    face patch 0 0 0
    set t ( t + 1 )
    ask drops [ set size ( 0.99 * size ) ]
    ]
end

;;; title procedures

to title
  zhome ;;; not too far away
  create-titleposts 1
    [
    set label labeltext1
    set color black
    set ycor 5
    ]
end

to titlezoom
  let t 0
    ask titleposts
    [
    hide-turtle
    set label labeltext2
    show-turtle
    ]
  while [ t < 15 ] ;;; 15 steps of 0.1 unit, or 1.5 second zoom
    [
    wait 0.1 ;;; speed of zoom, 0.1 is medium
    setxyz -2 -2 ( 33 - t ) ;;; decriment 1 unit
    set t ( t + 1 )
    ]
end

;;; reporters
;;; ==============================================
;;; conversion functions, world-coords <--> turtle-screen-coords:
;;; horizontal: (u <--> x), vertical (v <--> y), deep (w <--> z)
;;; ----------------------------------------------
;;; (u <-- x): u = convert(x)
to-report horizconvert [ x ]
  let u (deltau * ( x - xmin ) / deltax) + umin
  report u
end

;;; (u --> x): x = deconvert(u)
to-report horizdeconvert [ u ]
  let x (deltax * ( u - umin ) / deltau) + xmin
  report x
end

;;; (v <-- y): v = convert(y)
to-report vertconvert [ y ]
  let v (deltav * ( y - ymin ) / deltay) + vmin
  report v
end

;;; (v --> y): y = deconvert(v)
to-report vertdeconvert [ v ]
  let y (deltay * ( v - vmin ) / deltav) + ymin
  report y
end

;;; (w <-- z): w = convert(z)
to-report deepconvert [ z ]
  let w (deltaw * ( z - zmin ) / deltaz) + wmin
  report w
end

;;; (w --> z): z = deconvert(w)
to-report deepdeconvert [ w ]
  let z (deltaz * ( w - wmin ) / deltaw) + zmin
  report z
end

;;; ==============================================

;; calculate the horizontal component of the map where the turtle is located
to-report map-x [ x y z] ;; turtle procedure
  let utemp1 horizconvert x
  let vtemp1 vertconvert y
  let wtemp1 deepconvert z
  let utemp2 map-u utemp1 vtemp1 wtemp1
  let xtemp horizdeconvert utemp2
  report xtemp
end

;; calculate the vertical component of the map where the turtle is located
to-report map-y [ x y z] ;; turtle procedure
  let utemp1 horizconvert x
  let vtemp1 vertconvert y
  let wtemp1 deepconvert z
  let vtemp2 map-v utemp1 vtemp1 wtemp1
  let ytemp vertdeconvert vtemp2
  report ytemp
end

;; calculate the depth component of the map where the turtle is located
to-report map-z [ x y z] ;; turtle procedure
  let utemp1 horizconvert x
  let vtemp1 vertconvert y
  let wtemp1 deepconvert z
  let wtemp2 map-w utemp1 vtemp1 wtemp1
  let ztemp deepdeconvert wtemp2
  report ztemp
end

;;; and at last, the map in world coords
;;; LORENZ odes with euler method

to-report map-u [ u v w ]
  let s 10
  report u + stepsize * s * ( v - u )
end

to-report map-v [ u v w ]
  ;;; let r 28
  report v + stepsize * ( r * u - v - u * w )
end

to-report map-w [ u v w ]
  let b 8 / 3
  report w + stepsize * ( u * v - b * w) ;;; c is global from a slider
end

;;; end of lorenz.nlogo procedures
@#$#@#$#@
GRAPHICS-WINDOW
278
18
492
253
25
25
4.0
0
20
1
1
1
0
1
1
1
-25
25
-25
25
-25
25
1

BUTTON
13
21
127
54
setup
setup
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
10
143
124
176
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
T

SLIDER
514
24
686
57
r
r
0.0
50
50
1
1
NIL

BUTTON
10
186
124
219
NIL
clear
NIL
1
T
OBSERVER
T
NIL
NIL
T

SLIDER
516
137
691
170
stepsize
stepsize
0
0.01
0.0050
0.0010
1
NIL

CHOOSER
517
79
655
124
dropcolor
dropcolor
15 25 45 65 85 125
5

BUTTON
13
103
126
136
NIL
step100
NIL
1
T
OBSERVER
T
NIL
NIL
T

MONITOR
9
231
76
276
NIL
totaltime
3
1
11

BUTTON
137
144
230
177
NIL
revolveXZ
T
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
142
190
227
223
NIL
zoom-in
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
190
232
263
265
NIL
zhome
NIL
1
T
OBSERVER
T
NIL
NIL
T

SLIDER
517
182
691
215
sleeptime
sleeptime
0
0.03
0.0050
0.0050
1
NIL

BUTTON
14
62
99
95
NIL
movie#1
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
148
24
226
57
NIL
movie#0
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
106
62
184
95
NIL
movie#2
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
191
63
269
96
NIL
movie#3
NIL
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
140
106
230
139
NIL
revolveXY
T
1
T
OBSERVER
T
NIL
NIL
T

BUTTON
99
235
168
268
NIL
xhome
NIL
1
T
OBSERVER
T
NIL
NIL
T

@#$#@#$#@
WHAT IS IT?
-----------
euler integration of the lorenz attractor
green square moves along the attractor leaving drops of dropcolor behind
the 'go" button cycles through 11 dropcolors of 100 drops each
OR, you may choose a dropcolor and and "step100" to leave 100 drops
the 'clear" button clears to gray

good values for the control parameter (slide) R are near the famous bifurcations:
increasing R through ---

 1.000, point attractor at origin splits to two point attractors
13.926, homoclinic tangency
24.06, onset of chaos

cf sparrow, pp. 2,9,13,31
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 30 30 240

circle 2
false
0
Circle -7500403 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7500403 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D Preview 4
@#$#@#$#@
setup
place-particle 0 screen-edge-y - 3
repeat 50000 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
