breed [bees bee]
breed [sites site]
breed [suns sun]
bees-own [ground-bee? target target-angle interest dist-to-hive circle-switch temp-x-dance temp-y-dance temp-z-dance beetimer dancing? dance-time]
patches-own [swarm? suitable?]
suns-own [init-x init-y init-z]
sites-own [dist-to-center quality]
globals [sun-angle ];oneplane?]

to setup
  ca
  setup-swarm
  setup-ground
  setup-sky
  setup-site
  setup-sun
  setup-bee
 ; set oneplane? false
  reset-ticks
end
  
to setup-swarm
  ask patches with [
    pxcor > -10 and pxcor < 10 and 
    pzcor > -10 and pzcor < 10 and 
    pycor = 0 and distancexyz 0 0 0 < 5
    ] [set pcolor brown set swarm? true]
   
end

to setup-ground
  ask patches with [pzcor = -16 ] [set pcolor green ];if distancexyz 0 0 -16 > 8 [set suitable? true]]
end

to setup-sky
  ask patches with [pycor = 16 ] [set pcolor scale-color blue pzcor 20 0]
    ask patches with [abs pxcor = 16 ] [set pcolor scale-color blue pzcor 20 0]
end

to setup-site
    create-sites 1 [
      set heading 0 
      set pitch 0 
      set roll 0 
      set shape "square" 
      set size 4 
      set color pink 
      set quality site-quality
      set label word "Q= " quality
      place-site
      set dist-to-center distancexyz 0 0 -14
      ask patch-at -1 -3 -2 [set plabel word "X= " [xcor] of myself]
      ask patch-at 1 0 -2 [set plabel word "Y= " [ycor] of myself]
      ]
end

to place-site
  set xcor 14 - random 29 set ycor 14 - random 29 set zcor -14 if distancexyz 0 0 -14 < 8 [place-site]
end

to setup-sun
  create-suns 1 [
    setxyz sun-position 14 14 
    set init-x 14 set init-y 14 set init-z 14 
    set shape "circle" 
    set size 4 
    set color red
    ]
end

to setup-bee
  create-bees 1 [
    set ycor -1 set shape "bee" set size 2       
    set heading 0 
    set pitch 90 
    set roll 0 
  draw-arrow
    set dancing? true
    set ground-bee? false
    set target one-of sites
    set dist-to-hive [dist-to-center] of target
    set interest [quality] of target
    set color [color] of target
    set circle-switch 1
      ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;run time;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
  every 0.1 [
  ask suns [set xcor sun-position]
  ask bees [if dancing? [dance]]
  tick]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;dance;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to-report dance-angle
   let site-angle atan [xcor] of one-of sites [ycor] of one-of sites 
   set sun-angle atan [xcor] of one-of suns [ycor] of one-of suns
   report site-angle - sun-angle
end

to dance
  ifelse dance-time <= interest [
    pd
      repeat 2 [                      
      waggle 
      make-semicircle 
      set dance-time dance-time + 1
    ]
      ][
      pu
      set dancing? false
      ]
end

to make-semicircle
  let num-of-turns 1 / interest * 2600          ;calculate the size of the semicircle. 2600 and 5 (in pi / 5) are numbers selected by trial and error to make the dance path look good 
  let angle-per-turn 180 / num-of-turns
  let semicircle dist-to-hive * pi / 6
  if circle-switch = 1 [
  ifelse ground-bee? [set heading sun-angle set pitch 0 set roll 0][set heading 0 set pitch 90 set roll 0]
   rt dance-angle 
 lt 90
    repeat num-of-turns [
      lt angle-per-turn fd (semicircle / 180 * angle-per-turn)
    ]
  ]
  if circle-switch = -1 [
  ifelse ground-bee? [set heading sun-angle set pitch 0 set roll 0][set heading 0 set pitch 90 set roll 0]
      rt dance-angle  
      rt 90 
    repeat num-of-turns [
      rt angle-per-turn fd (semicircle / 180 * angle-per-turn)
    ]
  ]
  set circle-switch circle-switch * -1
  setxyz temp-x-dance temp-y-dance temp-z-dance 
  wait 0.1
end
    
to waggle                                       ; pointing the zigzag direction to the targe
  ifelse ground-bee? [set heading sun-angle set pitch 0 set roll 0][set heading 0 set pitch 90 set roll 0]
  rt dance-angle     
    set temp-x-dance xcor set temp-y-dance ycor set temp-z-dance zcor
  let waggle-switch 1                                    ; switch toggles between 1 and -1, which makes a bee dance a zigzag line by turning left and right
  lt 60 fd .2                                            ; first part of a zigzag line
  repeat (dist-to-hive - 2) * 2 [                        ; correlates the number of turns in the zigzag line with the distance between the swarm and the hive. the number 2 is selected by trial and error to make the dance path look good
    if waggle-switch = 1 [rt 120 fd .4]                  ; alternates left and right along the diameter line that points to the target
    if waggle-switch = -1 [lt 120 fd .4]
    set waggle-switch waggle-switch * -1
  ]
  ifelse waggle-switch = -1 [lt 120 fd .2][rt 120 fd .2] ; finish the last part of the zigzag line
  wait 0.1
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;one-plane;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to one-plane
;  ifelse oneplane? [stop][
  clear-drawing
  let bottom-swarm patch-set patches with [
  pxcor > -10 and pxcor < 10 and 
  pzcor < -5 and pzcor > -16 and
  pycor = 0 and 
  distancexyz 0 0 -15 < 5
    ]
  ask bees [if zcor > -14 [set zcor zcor - 1] ]
  ask suns [if zcor > -14 [set zcor zcor - 1]]
  ask-concurrent patches with [pcolor = brown] [if not member? self bottom-swarm [set pcolor 0] ask patch pxcor pycor (pzcor - 1) [set pcolor brown]]
  ask patches with [pzcor = -16] [set pcolor green]
  let slit patch-set patches with [pxcor > -5 and pxcor < 5 and pycor = 0 and pzcor = -16]
  if (item 0 [zcor] of bees with [not ground-bee?]) < -13 [ask bees [hatch 1 [set heading 0
    set pitch 90 
    set roll 0 
    draw-arrow die]] stop]
;  if any? slit with [pcolor = brown] [set oneplane? true]
;  ]
end

to ground-clone
  ask one-of bees [hatch 1 [
      set ground-bee? true
      set heading sun-angle 
    set pitch 0 
    set roll 0 
draw-arrow
    set color [color] of target
  ]]
end

to draw-arrow
  set color blue
  pd
  fd 4 rt 150 fd 1 bk 1 lt 300 fd 1 bk 1 rt 150 bk 4
  pu
end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
439
460
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
-16
16
1
0
1
ticks
30.0

BUTTON
12
11
78
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
84
12
147
45
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
51
149
84
NIL
one-plane
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
16
147
152
192
NIL
dance-angle
17
1
11

SLIDER
170
12
342
45
sun-position
sun-position
-14
14
4
1
1
NIL
HORIZONTAL

SLIDER
169
62
341
95
site-quality
site-quality
0
100
50
1
1
NIL
HORIZONTAL

MONITOR
15
202
154
247
dance-time
[dance-time] of one-of bees
17
1
11

BUTTON
14
89
150
122
NIL
ground-clone
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model explains how a waggle dance encodes spatial information of a hive site. In the view, a swarm is placed at the center. A honeybee is on the surface of the swarm, which is perpendicular to the ground. The sun is in the sky and a hive site is on the ground. For more information about honeybees' hive-finding behavior, see BeeSmart Hive Finding in the NetLogo Models Library.

## HOW IT WORKS

The model calculates the angle between the sun, the swarm, and the hive site (Angle sun-swarm-site) by using atan of the coordinates of the projects of these objects on the xy plane (the ground). Then the bee on the swarm produces waggle dance patterns (a circle with a squiggly inside) to represent the location information of the hive site in relation to the position of the sun.

## HOW TO USE IT

When the setup button is clicked, a bird view of the world is presented. Click and hold any part of the view and drag upwards until the view turns 90 degree and the blue arrow on the swarm at the center is pointing upwards. Click go to run the model. 

## THINGS TO NOTICE

Notice the angle between the sun, the swarm, and the hive site (Angle sun-swarm-site) and the angle between the up direction (the blue arrow) and the squiggly. These two angles should be the same.
Also notice the relationship between the length of the squiggly and the distance between the swarm and the hive site. The farther the site, the longer the squiggly. 

## THINGS TO TRY

Use the site-quality and the sun-position sliders to change these two parameters, and observe how the dance pattern change accordingly. You may need to click setup for the changes in the sliders to take effect.
Click the one-plane button and then unclick it. Notice how all objects are sunk to the ground plane. Click the ground-clone button to create a clone of the bee. This clone dances exactly the same pattern, but the dance is on the ground plane with the "up" direction pointing to the sun. Compare and find the relations between the dance on the vertical swarm plane and the ground plane.

## EXTENDING THE MODEL

Now the hive site is placed randomly in the world. One way to extend the model is to add sliders to control the position of the hive site. 
Currently, the sun does not move as time passes. However, in the real world, the sun does move. Adding an automatic sun movement is another way to extend this model. 

## NETLOGO FEATURES

This model uses NetLogo 3D, where the patches are actually cubes. The movement of the swarm is actually recoloring of patch cubes that cannot move.

## RELATED MODELS

Guo, Y. and Wilensky, U. (2014). NetLogo BeeSmart - Hive Finding model. http://ccl.northwestern.edu/netlogo/models/BeeSmart-HiveFinding. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL. 

## CREDITS AND REFERENCES

Guo, Y., & Wilensky, U. (2014) Beesmart: a microworld for swarming behavior and for learning complex systems concepts. Proceedings of the Constructionism 2014 Conference. Vienna, Austria. August 2014.

Seeley, T. D. (2010). Honeybee democracy. Princeton, NJ: Princeton University Press.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bee
true
0
Polygon -1184463 true false 152 149 77 163 67 195 67 211 74 234 85 252 100 264 116 276 134 286 151 300 167 285 182 278 206 260 220 242 226 218 226 195 222 166
Polygon -16777216 true false 150 149 128 151 114 151 98 145 80 122 80 103 81 83 95 67 117 58 141 54 151 53 177 55 195 66 207 82 211 94 211 116 204 139 189 149 171 152
Polygon -7500403 true true 151 54 119 59 96 60 81 50 78 39 87 25 103 18 115 23 121 13 150 1 180 14 189 23 197 17 210 19 222 30 222 44 212 57 192 58
Polygon -16777216 true false 70 185 74 171 223 172 224 186
Polygon -16777216 true false 67 211 71 226 224 226 225 211 67 211
Polygon -16777216 true false 91 257 106 269 195 269 211 255
Line -1 false 144 100 70 87
Line -1 false 70 87 45 87
Line -1 false 45 86 26 97
Line -1 false 26 96 22 115
Line -1 false 22 115 25 130
Line -1 false 26 131 37 141
Line -1 false 37 141 55 144
Line -1 false 55 143 143 101
Line -1 false 141 100 227 138
Line -1 false 227 138 241 137
Line -1 false 241 137 249 129
Line -1 false 249 129 254 110
Line -1 false 253 108 248 97
Line -1 false 249 95 235 82
Line -1 false 235 82 144 100

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D 5.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
