
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

breed          [ farmers farmer ]
breed          [ extension-agents extension-agent ]

patches-own    [ soil-quality                       ;; score, normally distributed
                 soil-conservation-practised        ;; ?, false, true
                 owned-by                           ;; which turtle (farmer) owns the field
                 ]                                  
                 

farmers-own [    soil-conservation-decision         ;; not_accepted, accepted_not_adopted, adopted
                 acceptance-decision-score          ;; 0 = start, 1 = symptoms recognised, 2 = effects recognised, 3 = taken 
                                                    ;; serious, 4 = aware of methods, 5 = able to undertake, 6 = willing to 
                                                    ;; undertake, 7 = ready to unertake, 8 = accepted
                                  
              ;; household characteristics
                
                 age-of-decision-maker              ;; yrs, initially normally distributed
                 education-of-decision-maker        ;; normally distributed
                                  
                 successor                          ;; ?, Y/N, true / false
                 
                 decision-maker-does-labouring      ;; ?, Y/N, true / false
                 
                 size-of-household                  ;; ppl, normally distributed
  
              ;; economic attributes
                 
                 land-tenure-status                 ;; owned or rented
                 labour-access                      ;; ?, Y/N, true or false
                 credit-access                      ;; ?, Y/N, true or false
                 number-of-fields-owned             ;; No. of patches a farmer agent owns/rents
                 
                 
                 income                             ;; = no. of fields owned * soil quality of fields owned * knowledge of land
                 savings                            ;; normally distributed
                 consumption-requirement            ;; = size of household * consumption-reqiurement-per-individual
                 
                 risk-aversion                      ;; score, normally distributed
                 discount-rate                      ;; normally distributed
              
              ;; social attributes
              
                 cultural-inertia                   ;; score, normally distributed 
                 adherence-to-norms                 ;; score, normally distributed 
                 institution-attitude               ;; score, normally distributed 
                 influence-score                    ;; score, normally distributed 
              
              
              ;; other attributes
  
                 knowledge-of-land                  ;; same as age
                 knowledge-of-technology            ;; score, normally distributed 
                 extension-worker-contact           ;; ?, Y/N, ture of false,
                 
                 my-farm                            ;; group of patches owned by a turtle
                 
                 average-soil-quality-of-farm       ;; mean soil quality of my farm
                 
                 timeHadSWC                         ;; steps a farmer has practised SWC
                 timesDisadopted                    ;; count times a farmer disadopts
                 
                 %OfMyFarmwithSWC                   ;; % of patches of a farm with SWC
                 
                 ]
             
globals        [ number-of-shock-weather-events     ;; count shock weather events
                 decisions-to-accept                ;; count acceptance decisions
                 decisions-to-adopt                 ;; count adoption decisions
                 decisions-to-stop-adoption         ;; count disadoption decisions
                 case-study-name                    ;; case study name monitor
                 
                 IoD                                ;; Index of dissimilarity and its calculation (4 quadrants)
                 DareaA
                 DareaB
                 DareaC
                 DareaD
               
                  ]  
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;SETUP;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SETUP;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; load case study data for ease of use and 'playing'

to CasestudyTigray
  
   set average-age-of-decision-maker 47
   set average-years-of-education 4.79
   set average-size-of-household 4.6
   set average-savings 100
   set consumption-per-individual 200
   set average-risk-aversion 50
   set average-discount-rate 0.15
   set average-cultural-inertia 50
   set average-adherence-to-norms 59.4
   set average-institutional-attitude 50
   set average-influence-score 50
   set average-knowledge-of-tech 50
   set inital-proportion-farmers-practising-conservation 0.1
   set proportion-of-households-with-successor 0.422
   set proportion-of-households-with-decision-maker-labourer 0.9
   set proportion-of-households-own-land 0.75
   set proportion-of-households-with-labour-access 0.2
   set proportion-of-households-with-credit-access 0.1
   set proportion-of-households-with-extension-contact 0.574
   set death-age 60.5
   set case-study-name "Tigray"
   
   ;; different calibrated values for last two interaction types
   
   if interaction-types = "extension worker" [   set average-institutional-attitude 30 
                                                 set average-risk-aversion 75
                                                 set average-discount-rate 0.4
                                                 set average-cultural-inertia 80
                                                 set average-influence-score 30
                                                 set average-knowledge-of-tech 20 ]
   
   if interaction-types = "all"              [   set average-institutional-attitude 15 
                                                 set average-risk-aversion 90
                                                 set average-discount-rate 0.5
                                                 set average-cultural-inertia 90
                                                 set average-influence-score 15
                                                 set average-knowledge-of-tech 15 ]
   
end

to CaseStudySENigeria
  
   set average-age-of-decision-maker 54.6
   set average-years-of-education 7.01
   set average-size-of-household 4.52
   set average-savings 100
   set consumption-per-individual 200
   set average-risk-aversion 50
   set average-discount-rate 0.15
   set average-cultural-inertia 50
   ifelse random 10 > 4 [ set average-adherence-to-norms 40 ] [ set average-adherence-to-norms 60 ]
   set average-institutional-attitude 50
   set average-influence-score 50
   set average-knowledge-of-tech 50
   set inital-proportion-farmers-practising-conservation 0.1
   ifelse random 10 > 4 [ set proportion-of-households-with-successor 0.4 ]
                        [ set proportion-of-households-with-successor 0.6 ]
   set proportion-of-households-with-decision-maker-labourer 0.73
   set proportion-of-households-own-land 0.61
   set proportion-of-households-with-labour-access 0.745
   set proportion-of-households-with-credit-access 0.204
   set proportion-of-households-with-extension-contact 0.33
   set death-age 53
   set case-study-name "SE Nigeria"
   
   ;; different calibrated values for last two interaction types
   
   if interaction-types = "extension worker" [   set average-institutional-attitude 30 
                                                 set average-risk-aversion 75
                                                 set average-discount-rate 0.4
                                                 set average-cultural-inertia 80
                                                 set average-influence-score 30
                                                 set average-knowledge-of-tech 20 ]
   
   if interaction-types = "all"              [   set average-institutional-attitude 15 
                                                 set average-risk-aversion 90
                                                 set average-discount-rate 0.5
                                                 set average-cultural-inertia 90
                                                 set average-influence-score 15
                                                 set average-knowledge-of-tech 15 ]
  
end

to caseStudyCebu
  
   set average-age-of-decision-maker 48.2
   set average-years-of-education 4.4
   set average-size-of-household 4.8
   set average-savings 100
   set consumption-per-individual 200
   set average-risk-aversion 50
   set average-discount-rate 0.15
   set average-cultural-inertia 50
   if random 3 = 2 [ set average-adherence-to-norms 40 ] 
   if random 3 = 1 [ set average-adherence-to-norms 50 ]
   if random 3 = 0 [ set average-adherence-to-norms 60 ]
   set average-institutional-attitude 50
   set average-influence-score 50
   set average-knowledge-of-tech 50
   set inital-proportion-farmers-practising-conservation 0.1
   ifelse random 10 > 4 [ set proportion-of-households-with-successor 0.4 ]
                        [ set proportion-of-households-with-successor 0.6 ]
   ifelse random 10 > 4 [ set proportion-of-households-with-decision-maker-labourer 0.6 ] 
                        [ set proportion-of-households-with-decision-maker-labourer 0.9 ] 
   set proportion-of-households-own-land 0.45
   set proportion-of-households-with-labour-access 0.3
   set proportion-of-households-with-credit-access 0.3
   set proportion-of-households-with-extension-contact 0.08
   set death-age 73
   set case-study-name "Cebu"
   
   ;; different calibrated values for last two interaction types
   
   if interaction-types = "extension worker" [   set average-institutional-attitude 30 
                                                 set average-risk-aversion 75
                                                 set average-discount-rate 0.4
                                                 set average-cultural-inertia 80
                                                 set average-influence-score 30
                                                 set average-knowledge-of-tech 20 ]
   
   if interaction-types = "all"              [   set average-institutional-attitude 15 
                                                 set average-risk-aversion 90
                                                 set average-discount-rate 0.5
                                                 set average-cultural-inertia 90
                                                 set average-influence-score 15
                                                 set average-knowledge-of-tech 15 ]
  
end

;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;main setup;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  
  clear-all
  setup-patches-and-create-turtles
  set-farmer-attributes
  set-case-study-name
  my-update-plots
  reset-ticks
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;GO;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;GO;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;GO;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
  
  farmer-decision-start-point
  extension-agents-move
  update-patches 
  update-attributes
  ask farmers with [ soil-conservation-decision = "adopted" ] [ set timeHadSWC timeHadSWC + 1 ]
  IoDiss
  tick
  my-update-plots
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PROCEDURES IN SETUP;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PROCEDURES IN SETUP;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to setup-patches-and-create-turtles
  
  ;; creating pathes and turtles
  
  ask patches [
    
    ;; set initial soil quality
    
    set soil-quality random-normal 25 10
    
    let my-area patches in-radius 1
    
    if ( mean [ soil-quality ] of my-area ) > soil-quality [ set soil-quality soil-quality + 5 ]
    if ( mean [ soil-quality ] of my-area ) < soil-quality [ set soil-quality soil-quality - 5 ] 
    
    ;; set initial practice
    
    set soil-conservation-practised false 
    
    ;; set patch colors, brown no conservation, green conservation, 
    ;; darker shade means higher quality, lighter means lower quality
           
    if ( soil-quality < 25 ) and ( soil-conservation-practised = true ) [ set pcolor 59 ]
    if ( soil-quality >= 25 ) and ( soil-quality < 50 ) and ( soil-conservation-practised = true ) [ set pcolor 57 ]
    if ( soil-quality >= 50 ) and ( soil-quality < 75 ) and ( soil-conservation-practised = true ) [ set pcolor 54 ]
    if soil-quality >= 75 and (soil-conservation-practised = true ) [ set pcolor 52 ]
    
    if ( soil-quality < 25 ) and ( soil-conservation-practised = false ) [ set pcolor 39 ]
    if ( soil-quality >= 25 ) and ( soil-quality < 50 ) and ( soil-conservation-practised = false ) [ set pcolor 37 ]
    if ( soil-quality >= 50 ) and ( soil-quality < 75 ) and ( soil-conservation-practised = false ) [ set pcolor 34 ]
    if soil-quality >= 75 and (soil-conservation-practised = false ) [ set pcolor 32 ]
    ]

  ;;  create population
  
  ;;  create new agents, spread randomly, set appearance ( extension agents first )
  
  if ( interaction-types = "extension worker" ) or ( interaction-types = "all" ) 
  
                                [ create-extension-agents ( number-of-initial-farmers / 20 )  [                         
                                  setxy random-pxcor random-pycor
                                  set shape "triangle"
                                  set color red 
                                  set size 1.5
  ]]
                                  create-farmers number-of-initial-farmers  [ 
                                  setxy random-pxcor random-pycor
                                  if any? other farmers-here [ move-to one-of patches with [ not any? farmers-here ] ]
                                  set shape "circle"
                                  set color red 
                                  set size 1]
                                  
                                  ;; turtle owns patches it's nearest to
  
                                  ask patches 
                                  
                                [ set owned-by min-one-of farmers [distance myself] ] 
  
end

;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;; 
;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;;
;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;; setting farmers attributes;;

to set-farmer-attributes
  
;; setup farmer parameters, using case study data for a mean of normal distribution, SD set at a plausible level

ask farmers [ 
  
              ;; basics for outputs
              
              set timeHadSWC 0
              set timesDisadopted 1 ;; set at 1 to avoid division by zero when used in outputs/plots
              
              ;; score based parameters
                                  
              set age-of-decision-maker random-normal average-age-of-decision-maker 10
              set education-of-decision-maker random-normal average-years-of-education 3
              set size-of-household random-normal average-size-of-household 3
                                  
              set number-of-fields-owned count patches with [ owned-by = myself ]                                  
              set my-farm patches with [ owned-by = myself ]
                                  
              set income 
              (  ( number-of-fields-owned *  mean [ soil-quality ] of my-farm ) + knowledge-of-land )
                                  
              set savings random-normal average-savings 40 
              set consumption-requirement ( size-of-household * consumption-per-individual ) 
                                                   
              set risk-aversion random-normal average-risk-aversion 20 
              ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                [ set risk-aversion risk-aversion - 30 ] )
              set discount-rate random-normal average-discount-rate 0.07
                                  
              set cultural-inertia random-normal average-cultural-inertia 20 
              ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                [ set cultural-inertia cultural-inertia - 30 ] )
              set adherence-to-norms random-normal average-adherence-to-norms 20
              set institution-attitude random-normal average-institutional-attitude 20 
              ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                [ set institution-attitude institution-attitude  + 30 ] )
              set influence-score random-normal average-influence-score 20
  
              set knowledge-of-land age-of-decision-maker 
              set knowledge-of-technology random-normal average-knowledge-of-tech 20 
              ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                [ set knowledge-of-technology knowledge-of-technology - 30 ] )
                                  
              set average-soil-quality-of-farm mean [ soil-quality ] of my-farm
                                  
              set soil-conservation-decision "not_accepted"  ]
                                  
              ;; some farmers already practise SC
                                  
              ask n-of ( inital-proportion-farmers-practising-conservation * count farmers ) farmers 
                [ set soil-conservation-decision "adopted" 
                  set color black ask n-of (0.5 * count my-farm) my-farm 
                       [ set soil-conservation-practised true 
                         if ( soil-quality < 25 ) and ( soil-conservation-practised = true ) 
                              [ set pcolor 59 ]
                         if ( soil-quality >= 25 ) and ( soil-quality < 50 ) and ( soil-conservation-practised = true ) 
                              [ set pcolor 57 ]
                         if ( soil-quality >= 50 ) and ( soil-quality < 75 ) and ( soil-conservation-practised = true ) 
                              [ set pcolor 54 ]
                         if soil-quality >= 75 and ( soil-conservation-practised = true ) 
                              [ set pcolor 52 ]
                              ] ] 
                                  
              ask farmers [ if soil-conservation-decision = "not_accepted" [ set acceptance-decision-score 0 ]
                            if soil-conservation-decision = "accepted_not_adopted" [ set acceptance-decision-score 7 ]
                            if soil-conservation-decision = "adopted" [ set acceptance-decision-score 7 ] 
                                  
                                  ] 
                               
              ;; proportion Y/N parameters
                                                                                                                                
              ask farmers [ set successor false ]
                                  
              ask n-of ( proportion-of-households-with-successor * count farmers ) farmers [ set successor true ]
                                  
              ask farmers [ set decision-maker-does-labouring false ]
                                  
              ask n-of ( proportion-of-households-with-decision-maker-labourer * count farmers ) farmers 
              [ set decision-maker-does-labouring true ]
                                   
              ask farmers [ set land-tenure-status "rented" ]
                                  
              ask n-of ( proportion-of-households-own-land * count farmers ) farmers 
              [ set land-tenure-status "owned" ]
                                  
              ask farmers [ set labour-access false ]
                                  
              ask n-of ( proportion-of-households-with-labour-access * count farmers ) farmers 
              [ set labour-access true ]
                                  
              ask farmers [ set credit-access false ]
                                  
              ask n-of ( proportion-of-households-with-credit-access * count farmers ) farmers 
              [ set credit-access true ]
                                  
              ask farmers [ set extension-worker-contact false ]
                                  
              ask n-of ( proportion-of-households-with-extension-contact * count farmers ) farmers 
              [ set extension-worker-contact true ]
                                                                     
end 

;; double checking labelling of run using death age

to set-case-study-name
  if death-age = 60.5 [ set case-study-name "Tigray" ]
  if death-age = 53 [ set case-study-name "SE Nigeria" ]
  if death-age = 73 [ set case-study-name "Cebu" ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PROCEDURES IN GO;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PROCEDURES IN GO;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; farmers have to start their decision in right place each tick so...

to farmer-decision-start-point
  ask farmers [ if soil-conservation-decision = "not_accepted" OR soil-conservation-decision = "accepted_not_adopted" 
    [ ask my-farm [ set soil-conservation-practised false ] ] ]
  
  ask farmers [ if any? my-farm with [ soil-conservation-practised = true ] [ run-continued-use-decision]
                if not any? my-farm with [ soil-conservation-practised = true ] [ run-decide-between-accept-and-adopt ]]
  
end

;; farmers current 'opinion' affects which decision procedure to now run

to run-decide-between-accept-and-adopt
  
       if soil-conservation-decision = "not_accepted" [ run-acceptance-decision  ]
       if soil-conservation-decision = "accepted_not_adopted" [ run-adoption-decision ]
       if soil-conservation-decision = "adopted" [ run-continued-use-decision ]
                
end

;; choose which stage of acceptance decision to run according to current 'opinion'
  
to run-acceptance-decision 
  
 ;; 10% probability of accepting need for SWC by chance
  
 ifelse random 100 > 89 [ accept-conservation ] [
 if acceptance-decision-score = 0 [ degradation-symptoms-recognised ]
 if acceptance-decision-score = 1 [ degradation-effects-recognised  ]
 if acceptance-decision-score = 2 [ degradation-taken-serious ]
 if acceptance-decision-score = 3 [ aware-of-conservation-methods ]
 if acceptance-decision-score = 4 [ able-to-undertake-conservation ]
 if acceptance-decision-score = 5 [ willing-to-undertake-conservation ]
 if acceptance-decision-score = 6 [ ready-to-undertake-conservation ]
 if acceptance-decision-score = 7 [ accept-conservation ]
 ]
 
end

;; the following 8 procedures are the acceptance decision process

to degradation-symptoms-recognised
           
           let deg-symp-recog ( ( 100 - soil-quality ) + knowledge-of-land )
           
           if  ( deg-symp-recog > 100 ) and ( decision-maker-does-labouring = true ) 
           [ set acceptance-decision-score  1 ]
           
end
  
to degradation-effects-recognised          
           
            let deg-eff-recog 
            (( 100 - age-of-decision-maker ) + knowledge-of-land + education-of-decision-maker + ( 100 - cultural-inertia ))
            
            if  ( deg-eff-recog > 125 ) and ( extension-worker-contact = true ) 
            [ set acceptance-decision-score 2 ] 
           
end

to degradation-taken-serious
 
            if (  extension-worker-contact = true ) and ( land-tenure-status = "owned" ) [ set acceptance-decision-score 3 ]
           
end

to aware-of-conservation-methods
 
            if ( knowledge-of-technology > 60 ) and (  extension-worker-contact = true ) [ set acceptance-decision-score 4 ]
           
end
 
to able-to-undertake-conservation

            if ( age-of-decision-maker < 75 ) and ( labour-access = true ) and 
               (  extension-worker-contact = true ) and ( credit-access = true ) and ( land-tenure-status = "owned" ) 
               [ set acceptance-decision-score 5 ]
               
            if ( age-of-decision-maker < 75 ) and ( size-of-household > 3 )  and 
               (  extension-worker-contact = true ) and ( credit-access = true ) and ( land-tenure-status = "owned" ) 
               [ set acceptance-decision-score 5 ]
               
            if ( age-of-decision-maker < 75 ) and ( labour-access = true ) and 
               (  extension-worker-contact = true ) and ( savings > 75 ) and ( land-tenure-status = "owned" ) 
               [ set acceptance-decision-score 5 ]
               
            if ( age-of-decision-maker < 75 ) and ( size-of-household > 3 )  and 
               (  extension-worker-contact = true ) and ( savings > 75 ) and ( land-tenure-status = "owned" ) 
               [ set acceptance-decision-score 5 ]
           
end
 
to willing-to-undertake-conservation

            let willing 
            ((  100 - ( discount-rate * 100 ) ) + ( 100 - cultural-inertia ) + 
              institution-attitude + ( 100 - age-of-decision-maker ))
              
            if ( willing > 100 ) and ( successor = true ) and ( decision-maker-does-labouring = true ) 
            [ set acceptance-decision-score 6 ]
           
end
 
to ready-to-undertake-conservation

            let ready ( ( 100 - risk-aversion ) + savings + income )
            
            if ( ready > 200 ) [ set acceptance-decision-score 7 ]
           
end

to accept-conservation

    set soil-conservation-decision "accepted_not_adopted"
    set decisions-to-accept decisions-to-accept + 1
    set color blue
    ask my-farm [set soil-conservation-practised false ]
  
end

;; adoption decision - run once acceptance is true

to run-adoption-decision
  
  if ( risk-aversion > 80 ) 
      
          [ set soil-conservation-decision "accepted_not_adopted" 
            set color blue ask my-farm [ set soil-conservation-practised false ] ]                                    
                        
  if ( risk-aversion > 60 ) and ( risk-aversion <= 80 ) and (  extension-worker-contact = true )
  
          [ set soil-conservation-decision "adopted" 
            set color black 
            set decisions-to-adopt decisions-to-adopt + 1 
            ask n-of ( 0.1 * count my-farm ) my-farm [ set soil-conservation-practised true ]]
  
  if ( risk-aversion > 40 ) and ( risk-aversion <= 60 ) and (  extension-worker-contact = true )
  
          [ set soil-conservation-decision "adopted" 
            set color black 
            set decisions-to-adopt decisions-to-adopt + 1 
            ask n-of ( 0.25 * count my-farm ) my-farm [ set soil-conservation-practised true ]]
 
  if ( risk-aversion > 20 ) and ( risk-aversion <= 40 ) and (  extension-worker-contact = true ) 
  
          [ set soil-conservation-decision "adopted" 
            set color black 
            set decisions-to-adopt decisions-to-adopt + 1 
            ask n-of ( 0.5 * count my-farm ) my-farm [ set soil-conservation-practised true ]]
  
  if ( risk-aversion <= 20 ) and (  extension-worker-contact = true )
  
          [ set soil-conservation-decision "adopted" 
            set color black 
            set decisions-to-adopt decisions-to-adopt + 1 
            ask n-of ( 0.75 * count my-farm ) my-farm [ set soil-conservation-practised true ]]
  
  
end

;; contined use decision

to run-continued-use-decision
  
  ;; increase or reduce adoption dependent on results ie., income
  
  if ( income > consumption-requirement ) 
  [ ask n-of ( 0.2 * count my-farm with [ soil-conservation-practised = false ] ) 
    my-farm with [ soil-conservation-practised = false ] 
    [ set soil-conservation-practised  true  ] ]
  
  if ( income < consumption-requirement ) 
  [ ask n-of ( 0.2 * count my-farm with [ soil-conservation-practised = true ] ) 
    my-farm with [ soil-conservation-practised = true ]  
    [ set soil-conservation-practised false ] ]
  
  
 ;; if very low adoption, stop altogether
  
  if ( soil-conservation-decision = "adopted" ) and 
  ( count my-farm with  [ soil-conservation-practised = true ] < ( 0.1 * count my-farm )) 
  
  [ set soil-conservation-decision "accepted_not_adopted" 
    set color blue 
    set decisions-to-stop-adoption decisions-to-stop-adoption + 1  
    set timesDisadopted timesDisadopted + 1
    ask my-farm [ set soil-conservation-practised false ] ]
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; extension agents have to move so...

to extension-agents-move
  
  if ( interaction-types = "extension worker" ) or ( interaction-types = "all" ) 
  [ ask extension-agents [ set heading random 360 fd 10 ] ]
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;UPDATE VARIABLES;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;UPDATE VARIABLES;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to update-patches
  
                ;; chance of shock weather event
  
                if random-float 100 < 4 [  set number-of-shock-weather-events number-of-shock-weather-events + 1
                                           ask patches 
                                           [ set soil-quality soil-quality - (( random-normal 0.5 0.1 ) * soil-quality ) ]]
                
  
  ask patches [ ;; random noise in soil quality
    
                ifelse random 2 = 1 [ set soil-quality soil-quality + 5.8 ] [ set soil-quality soil-quality - 5 ] 
                        
                ;; effect of conservation
                
                if ( soil-conservation-practised = true ) [ set soil-quality soil-quality + 8 ] 
                
                if ( soil-conservation-practised = false ) [ set soil-quality soil-quality - 1 ] 
               ]
                 
                ;; fields around a field affect it 
                
  ask patches [ let my-area patches in-radius 1
    
                if ( mean [ soil-quality ] of my-area ) > soil-quality [ set soil-quality soil-quality + 5 ]
                if ( mean [ soil-quality ] of my-area ) < soil-quality [ set soil-quality soil-quality - 5 ] 
                
                ;; regulate scores within 0-100
                
                if soil-quality > 100 [ set soil-quality 95 ]  
                if soil-quality < 0 [ set soil-quality 5 ]               
                 
                ;; update colour of patches each tick 
                  
                if ( soil-quality < 25 ) and ( soil-conservation-practised = true ) 
                [ set pcolor 59 ]
                if ( soil-quality >= 25 ) and ( soil-quality < 50 ) and ( soil-conservation-practised = true ) 
                [ set pcolor 57 ]
                if ( soil-quality >= 50 ) and ( soil-quality < 75 ) and ( soil-conservation-practised = true ) 
                [ set pcolor 54 ]
                if soil-quality >= 75 and ( soil-conservation-practised = true ) 
                [ set pcolor 52 ]
    
                if ( soil-quality < 25 ) and ( soil-conservation-practised = false ) 
                [ set pcolor 39 ]
                if ( soil-quality >= 25 ) and ( soil-quality < 50 ) and ( soil-conservation-practised = false ) 
                [ set pcolor 37 ]
                if ( soil-quality >= 50 ) and ( soil-quality < 75 ) and ( soil-conservation-practised = false ) 
                [ set pcolor 34 ]
                if soil-quality >= 75 and ( soil-conservation-practised = false ) 
                [ set pcolor 32 ]
  ]
  
end

to update-attributes 
  
  ;; update income, consumption req, contact with ext, age, knowledge of land, knowledge of tech
  
  ask farmers [ 
    
                ;; calc prop of my farm with SWC
                
                set %OfMyFarmwithSWC round 
                ((( count my-farm with [ soil-conservation-practised = true ] ) / (count my-farm )) * 100 ) 
                
                ;; age and knowledge of land go up with time
    
                set age-of-decision-maker age-of-decision-maker + 0.25
                set knowledge-of-land age-of-decision-maker
                
                ;; update farm soil quality and income
                
                set average-soil-quality-of-farm mean [ soil-quality ] of my-farm
                set income  ( number-of-fields-owned *  mean [ soil-quality ] of my-farm ) + knowledge-of-land 
                
                ;; spatial / locality effects
                
                local-effects    ;; below - these are the interaction types
                
                ;; death - if have a successor all attributes stay same except age, 
                ;; if no successor, all change, soil cons decision will be back to not accepted
                
                if ( age-of-decision-maker > ( death-age * random-normal 1 0.2 ) ) and ( successor = true ) 
                [ set age-of-decision-maker 20 
                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-successor  
                  [ set successor false ] [set successor true ]] 
                
                
                if ( age-of-decision-maker > ( death-age * random-normal 1 0.2 ) ) and ( successor = false ) [ 
                  
                                  set age-of-decision-maker random-normal average-age-of-decision-maker 10
                                  set education-of-decision-maker random-normal average-years-of-education 3
                                  set size-of-household random-normal average-size-of-household 3
                                  
                                  set number-of-fields-owned count patches with [ owned-by = myself ]                                  
                                  set my-farm patches with [ owned-by = myself ]
                                  
                                  set income 
                                  ( number-of-fields-owned *  mean [ soil-quality ] of my-farm ) + knowledge-of-land
                                  
                                  set savings random-normal average-savings 40 
                                  set consumption-requirement ( size-of-household * consumption-per-individual )  
                                                   
                                  set risk-aversion random-normal average-risk-aversion 20 
                                  ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                                    [ set risk-aversion risk-aversion - 30 ] )
                                  set discount-rate random-normal average-discount-rate 0.07
                                  
                                  set cultural-inertia random-normal average-cultural-inertia 20 
                                  ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                                    [ set cultural-inertia cultural-inertia - 30 ] )
                                  set adherence-to-norms random-normal average-adherence-to-norms 20
                                  set institution-attitude random-normal average-institutional-attitude 20 
                                  ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                                    [ set institution-attitude institution-attitude  + 30 ] )
                                  set influence-score random-normal average-influence-score 20
  
                                  set knowledge-of-land age-of-decision-maker 
                                  set knowledge-of-technology random-normal average-knowledge-of-tech 20 
                                  ( if ( age-of-decision-maker < average-age-of-decision-maker ) 
                                    [ set knowledge-of-technology knowledge-of-technology - 30 ] )
                                  
                                  set average-soil-quality-of-farm mean [ soil-quality ] of my-farm
                                  
                                  set soil-conservation-decision "not_accepted" 
                                  set timesDisadopted timesDisadopted + 1
                                  set color red
                                                                            
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-successor  
                                  [ set successor false ] [set successor true ]
                                  
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-decision-maker-labourer 
                                  [ set decision-maker-does-labouring false ] [set decision-maker-does-labouring true ]
                                  
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-own-land 
                                  [ set land-tenure-status "rented" ] [set land-tenure-status "owned" ]
                                  
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-labour-access 
                                  [ set labour-access false ] [set labour-access true ]
                                  
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-credit-access 
                                  [ set credit-access false ] [set credit-access true ]
                               
                                  ifelse ( random-float 1 + 0.00001 ) > proportion-of-households-with-extension-contact 
                                  [ set extension-worker-contact false ] [set extension-worker-contact true ] 
  ]
             
  ]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;interaction effects;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to local-effects
  
                if interaction-types = "farmer groups" [ farmer-groups ]
                if interaction-types = "influential individuals" [ influential-individuals ]
                if interaction-types = "extension worker" [ extension-worker ]
                if interaction-types = "all" [ all-local-effects ]
                
end

to farmer-groups
  
                ;; if farmer effects turned on, and any or all of my group are using SC, and i have adherence to norms above 30, 
                ;; then 'increase' some variables and thus chance of adoption / acceptance
                   
                let my-farmer-group farmers in-radius 10  
                
                if ( adherence-to-norms > 50 ) and ( any? my-farmer-group with [ soil-conservation-decision = "adopted" ]  ) 
                           
                           [ set knowledge-of-technology knowledge-of-technology + ( 0.2 * knowledge-of-technology ) 
                             set risk-aversion risk-aversion - ( 0.2 * risk-aversion )
                             set cultural-inertia cultural-inertia - ( 0.2 * cultural-inertia )
                              ]
                
                if (adherence-to-norms > 50 ) and ( all? my-farmer-group [ soil-conservation-decision = "adopted" ] )
                
                           [ set knowledge-of-technology knowledge-of-technology + ( ( 2 * 0.2 ) * knowledge-of-technology ) 
                             set risk-aversion risk-aversion - ( ( 2 * 0.2 ) * risk-aversion )
                             set cultural-inertia cultural-inertia - ( ( 2 * 0.2 ) * cultural-inertia )
                              ]
                           
                if ( soil-conservation-decision = "not_accepted" ) and 
                  (( count my-farmer-group with [ soil-conservation-decision = "adopted" ]) > 
                    ( 0.75 * count my-farmer-group )) and ( adherence-to-norms > 50 )
                
                      [ set soil-conservation-decision "accepted_not_adopted" 
                        set color blue 
                        set decisions-to-accept decisions-to-accept + 1 
                        ask my-farm [ set soil-conservation-practised false 
                        ]]
                             
end

to influential-individuals
  
  ;; like a leader some agents have very high influence over others in their group- 
  ;; others will  take on their scores - like a leader
  
  let my-farmer-group farmers in-radius 10 
  
  if influence-score > 80 [ ask my-farmer-group [ 
      
                             set knowledge-of-technology [ knowledge-of-technology ] of myself 
                             set risk-aversion [ risk-aversion ] of myself
                             set cultural-inertia [ cultural-inertia ] of myself
      
  ]]
  
end

to extension-worker
  
  ;; extension agents roam around randomly and set new scores for farmers..
  
  if any? extension-agents in-radius 1
  
  [                          set knowledge-of-technology knowledge-of-technology + ( 0.3 * knowledge-of-technology )  
                             set risk-aversion risk-aversion - ( 0.3 * risk-aversion )
                             set cultural-inertia cultural-inertia - ( 0.3 * cultural-inertia )
                             set extension-worker-contact true
                             
                             if ( random 4 >= 2 ) and ( soil-conservation-decision = "not_accepted" ) 
                             [ set soil-conservation-decision "accepted_not_adopted" 
                               set color blue 
                               set decisions-to-accept decisions-to-accept + 1 
                               ask my-farm [set soil-conservation-practised false ]]
  ]
  
end

to all-local-effects
  
  let my-farmer-group farmers in-radius 10  
                
                if ( adherence-to-norms > 50 ) and ( any? my-farmer-group with [ soil-conservation-decision = "adopted" ]  ) 
                           
                           [ set knowledge-of-technology knowledge-of-technology + ( 0.2 * knowledge-of-technology ) 
                             set risk-aversion risk-aversion - ( 0.2 * risk-aversion )
                             set cultural-inertia cultural-inertia - ( 0.2 * cultural-inertia )
                              ]
                
                if (adherence-to-norms > 50 ) and ( all? my-farmer-group [ soil-conservation-decision = "adopted" ] )
                
                           [ set knowledge-of-technology knowledge-of-technology + ( ( 2 * 0.2 ) * knowledge-of-technology ) 
                             set risk-aversion risk-aversion - ( ( 2 * 0.2 ) * risk-aversion )
                             set cultural-inertia cultural-inertia - ( ( 2 * 0.2 ) * cultural-inertia )
                              ]
                           
                if ( soil-conservation-decision = "not_accepted" ) and 
                (( count my-farmer-group with [ soil-conservation-decision = "adopted" ]) > 
                  ( 0.75 * count my-farmer-group )) and ( adherence-to-norms > 50 ) 
                
                   [ set soil-conservation-decision "accepted_not_adopted" 
                     set color blue 
                     set decisions-to-accept decisions-to-accept + 1 
                     ask my-farm [set soil-conservation-practised false ] ]     
  
  if influence-score > 80 [ ask my-farmer-group [ 
      
                             set knowledge-of-technology [ knowledge-of-technology ] of myself 
                             set risk-aversion [ risk-aversion ] of myself
                             set cultural-inertia [ cultural-inertia ]  of myself ] ]
  
  if any? extension-agents in-radius 1
  
  [                          set knowledge-of-technology knowledge-of-technology + ( 0.6 * knowledge-of-technology )  
                             set risk-aversion risk-aversion - ( 0.6 * risk-aversion )
                             set cultural-inertia cultural-inertia - ( 0.6 * cultural-inertia )
                             set extension-worker-contact true
                             
                             if ( random 4 >= 2 ) and ( soil-conservation-decision = "not_accepted" ) 
                             [ set soil-conservation-decision "accepted_not_adopted" 
                               set color blue 
                               set decisions-to-accept decisions-to-accept + 1 
                               ask my-farm [set soil-conservation-practised false ]]
                               ]
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;PLOTS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PLOTS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to my-update-plots
  
  set-current-plot "percentage of fields with SWC"
  set-current-plot-pen "percentage of fields with conservation"
  plot ((  ( count patches with [ soil-conservation-practised = true ])  / count patches ) * 100 )
  
  
  set-current-plot "percentage of farmers adopted SWC"
  set-current-plot-pen "default"
  plot (( count farmers with [ soil-conservation-decision = "adopted" ] ) / count farmers ) * 100
   
end


;;;;;;;;;;;;;;;;;;;;;;;;index of dissimilarity;;;;;;;;;;;

to IoDiss
  ; D = 0.5(abs)sum(b/B - w/W), over the 4 areas.
   
   set DareaA ( ( count farmers with [ xcor >= 0 and ycor >= 0 and soil-conservation-decision = "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision = "adopted" ] )) - 
              ( ( count farmers with [ xcor >= 0 and ycor >= 0 and soil-conservation-decision != "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision != "adopted" ] ))
              
   set DareaB ( ( count farmers with [ xcor >= 0 and ycor < 0 and soil-conservation-decision = "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision = "adopted" ] )) - 
              ( ( count farmers with [ xcor >= 0 and ycor < 0 and soil-conservation-decision != "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision != "adopted" ] ))
              
   set DareaC ( ( count farmers with [ xcor < 0 and ycor < 0 and soil-conservation-decision = "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision = "adopted" ] )) - 
              ( ( count farmers with [ xcor < 0 and ycor < 0 and soil-conservation-decision != "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision != "adopted" ] ))
              
   set DareaD ( ( count farmers with [ xcor < 0 and ycor >= 0 and soil-conservation-decision = "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision = "adopted" ] )) - 
              ( ( count farmers with [ xcor < 0 and ycor >= 0 and soil-conservation-decision != "adopted" ] ) / 
                ( count farmers with [ soil-conservation-decision != "adopted" ] ))
              
   
   set IoD 0.5 * ( abs DareaA + abs DareaB + abs DareaC + abs DareaD ) 
 
  
end
@#$#@#$#@
GRAPHICS-WINDOW
550
275
1168
914
25
25
11.922
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
time steps
30.0

BUTTON
40
615
260
648
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
40
655
260
688
go
go\n  if ticks = 200 [stop]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
1250
75
1630
108
inital-proportion-farmers-practising-conservation
inital-proportion-farmers-practising-conservation
0
1
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
30
155
255
188
number-of-initial-farmers
number-of-initial-farmers
0
500
300
1
1
farms
HORIZONTAL

SLIDER
1250
355
1630
388
average-age-of-decision-maker
average-age-of-decision-maker
15
80
47
1
1
years
HORIZONTAL

SLIDER
1250
275
1630
308
average-years-of-education
average-years-of-education
0
10
4.79
0.01
1
years
HORIZONTAL

SLIDER
1250
115
1630
148
proportion-of-households-with-successor
proportion-of-households-with-successor
0
1
0.422
0.001
1
NIL
HORIZONTAL

SLIDER
1250
235
1630
268
proportion-of-households-with-decision-maker-labourer
proportion-of-households-with-decision-maker-labourer
0
1
0.9
0.01
1
NIL
HORIZONTAL

SLIDER
1250
155
1630
188
proportion-of-households-own-land
proportion-of-households-own-land
0
1
0.75
0.01
1
NIL
HORIZONTAL

SLIDER
1250
515
1630
548
proportion-of-households-with-labour-access
proportion-of-households-with-labour-access
0
1
0.2
0.01
1
NIL
HORIZONTAL

SLIDER
1250
555
1630
588
proportion-of-households-with-credit-access
proportion-of-households-with-credit-access
0
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
1250
195
1630
228
proportion-of-households-with-extension-contact
proportion-of-households-with-extension-contact
0
1
0.574
0.001
1
NIL
HORIZONTAL

PLOT
885
155
1170
275
Percentage of fields with SWC
t
NIL
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"percentage of fields with conservation" 1.0 0 -10899396 true "" ""

MONITOR
885
110
1170
155
Percentage of fields with SWC
( count patches with [ soil-conservation-practised = true ] / count patches ) * 100
0
1
11

SLIDER
1250
315
1630
348
death-age
death-age
40
100
60.5
0.5
1
years
HORIZONTAL

PLOT
560
155
885
275
Percentage of farmers adopted SWC
t
NIL
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" ""

CHOOSER
70
200
210
245
interaction-types
interaction-types
"none" "farmer groups" "influential individuals" "extension worker" "all"
0

MONITOR
560
110
885
155
Percentage of farmers adopted
( count farmers with [ soil-conservation-decision = \"adopted\" ] / count farmers ) * 100
1
1
11

SLIDER
1250
435
1630
468
average-discount-rate
average-discount-rate
0
0.5
0.15
0.01
1
NIL
HORIZONTAL

SLIDER
1250
475
1630
508
average-adherence-to-norms
average-adherence-to-norms
0
100
59.4
0.1
1
NIL
HORIZONTAL

SLIDER
1250
395
1630
428
average-size-of-household
average-size-of-household
0
10
4.6
0.1
1
NIL
HORIZONTAL

SLIDER
1250
635
1630
668
average-savings
average-savings
0
2000
100
50
1
NIL
HORIZONTAL

SLIDER
1250
675
1630
708
consumption-per-individual
consumption-per-individual
0
1000
200
50
1
NIL
HORIZONTAL

SLIDER
1250
715
1630
748
average-risk-aversion
average-risk-aversion
0
100
50
5
1
NIL
HORIZONTAL

SLIDER
1250
755
1630
788
average-cultural-inertia
average-cultural-inertia
0
100
50
5
1
NIL
HORIZONTAL

SLIDER
1250
795
1630
828
average-institutional-attitude
average-institutional-attitude
0
100
50
5
1
NIL
HORIZONTAL

SLIDER
1250
835
1630
868
average-influence-score
average-influence-score
0
100
50
5
1
NIL
HORIZONTAL

SLIDER
1250
595
1630
628
average-knowledge-of-tech
average-knowledge-of-tech
0
100
50
5
1
NIL
HORIZONTAL

PLOT
310
155
560
275
Decison Stages
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"No. Adopted" 1.0 0 -14439633 true "" "plot count farmers with [ soil-conservation-decision = \"adopted\" ]"
"No. Accepted" 1.0 0 -817084 true "" "plot count farmers with [ soil-conservation-decision = \"accepted_not_adopted\" ]"
"No. Not accepted" 1.0 0 -2674135 true "" "plot count farmers with [ soil-conservation-decision = \"not_accepted\" ]"

PLOT
310
660
550
805
Prop. with extension worker contact
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -8431303 true "" "plot ( count farmers with [extension-worker-contact = true] ) / count farmers"

MONITOR
310
110
560
155
Case Study (If applicable)
case-study-name
0
1
11

PLOT
310
515
550
660
IoD
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -2674135 true "" "plot IoD"

PLOT
310
395
550
515
Average time had SWC
NIL
NIL
0.0
200.0
0.0
15.0
false
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [ timeHadSWC / timesDisadopted ] of farmers"

PLOT
310
275
550
395
Histrogram % of farm with SWC
NIL
NIL
0.0
100.0
0.0
50.0
false
false
"" ""
PENS
"default" 1.0 1 -14439633 true "" "histogram [%OfMyFarmwithSWC] of farmers"

TEXTBOX
40
115
275
151
---1) SELECT MODEL---
16
0.0
1

TEXTBOX
55
560
250
596
---3) SETUP & GO---
16
0.0
1

TEXTBOX
320
70
1175
116
--------------------------------------------OUTPUTS------------------------------------------
16
0.0
1

BUTTON
70
360
215
393
Case Study: Tigray
CasestudyTigray
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
70
400
217
433
Case Study: Nigeria
CaseStudySENigeria
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
70
440
215
473
Case Study: Cebu
caseStudyCebu
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
90
705
240
740
NB: Always press setup before pressing GO
11
0.0
1

TEXTBOX
25
310
295
346
---2) SELECT CASE STUDY---
16
0.0
1

TEXTBOX
1260
30
1665
66
Use these sliders to change specific parameters
15
0.0
1

TEXTBOX
20
15
1260
61
WELCOME TO THE SWAP MODEL: BEFORE USING THE MODEL PLEASE SELECT THE \"INFO\" TAB ABOVE FOR MORE INFORMATION.
19
0.0
1

TEXTBOX
60
810
540
910
--------------------------------------KEY:--------------------------------------\nSoil (ENVIRONMENT): 	                             	Farmers(CIRCLES):	                 Extension agents(TRIANGLES)\n\nGreen = SWC practiced	                     Red = Not accepted SWC\nBrown = SWC not practiced		     Blue = Accepted but not adopted SWC\nDarker colour = 'healthier'                   Black = Adopted SWC\n-------------------------------------------------------------------------------	                                                 \n\n\n\n
10
0.0
1

TEXTBOX
445
545
535
590
Higher score = More dissimilarity
10
0.0
1

TEXTBOX
55
495
250
531
NB: Always re-confirm the case study after changing the interaction type
10
0.0
1

@#$#@#$#@
## WHAT IS THE SWAP MODEL?

The purpose of this model is to simulate the adoption decisions of farmers for soil and water conservation (SWC) measures. 

The model was developed as part of a PhD Thesis at the Centre for Research of Social Simulation, University of Surrey.

The model is intended to serves as: 1) a discussion and engagement tool to be used by SWC policy stakeholders, and 2) as an exploration of the framework of farmer behaviour and interaction used to represent farmers' decisions.

For more information please refer to the Thesis or contact Peter G Johnson (peter.johnson@surrey.ac.uk).

## HOW IT WORKS

The model includes a number of farmer 'agents', these are simple computer programs that make a decision about whether to use SWC measures or not. This decision is governed by the characteristics of the farmer 'agent'. Please see the accompanying documentation for a detailed explanation of how the characteristics of farmer 'agents' affect their decision.

## HOW TO USE IT

To 'play' with the model, first, select how many agents you would like to place in the model - this gives a sense of the effect of density of farmers. Second, pick the 'interaction' type. The interaction types describe different ways in which farmers interact with each other. Please see the accompanying documentation for a detailed explanation of the interaction types.

Next, select which case study you would like to use - this loads the appropriate data. You can alter specific parameters on the right hand side sliders.

Now you are ready to start the model, press setup, and then go. 

To function properly you must always press setup before pressing go, and re-confirm the case study choice if you change the interaction type at any point.

To run experiments with the model you will need to use the behaviourSpace tool.

## THINGS TO NOTICE

Once the model is running you can watch the level of soil and water conservation adoption by following the % of farmers, and % of fields graphs, and their respective 'monitors'.

You can also monitor the other outputs: number of farmers with each decision type, a histogram of the percentage of a farm with SWC, a histogram of the time a farm has had SWC, a IoD score which measures dissimilarity, and the proportion of farmers that have had extension contact.

You may want to compare multiple 'runs' of the model with different interaction types (none vs farmer groups vs influential individuals vs extension agents vs all) and for different case studies.

You may also want to compare different values for the farmer 'agents' characteristics beyond those in the case study data. Note, changes here can be small, so use tables to compare multiple runs. 

You can view the larger 'visualisation' of the model which shows (there is also a key on the interface tab):

Land with conservation being used: green
Land with NO conservation being used: brown

Farmer agents are cirlces, and extension agents (if present) are triangles.

Farmer agents that are NOT using conservation: red
Farmer agents that are using conservation: black
Farmer agents that are accept the need for conservation but are not using it yet: blue

## FURTHER DETAILS

More information can be found in the accompanying doumentation, or by contacting Peter G Johnson (peter.johnson@surrey.ac.uk)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person business
false
0
Rectangle -1 true false 120 90 180 180
Polygon -13345367 true false 135 90 150 105 135 180 150 195 165 180 150 105 165 90
Polygon -7500403 true true 120 90 105 90 60 195 90 210 116 154 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 183 153 210 210 240 195 195 90 180 90 150 165
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 76 172 91
Line -16777216 false 172 90 161 94
Line -16777216 false 128 90 139 94
Polygon -13345367 true false 195 225 195 300 270 270 270 195
Rectangle -13791810 true false 180 225 195 300
Polygon -14835848 true false 180 226 195 226 270 196 255 196
Polygon -13345367 true false 209 202 209 216 244 202 243 188
Line -16777216 false 180 90 150 165
Line -16777216 false 120 90 150 165

person farmer
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 60 195 90 210 114 154 120 195 180 195 187 157 210 210 240 195 195 90 165 90 150 105 150 150 135 90 105 90
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -13345367 true false 120 90 120 180 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 180 90 172 89 165 135 135 135 127 90
Polygon -6459832 true false 116 4 113 21 71 33 71 40 109 48 117 34 144 27 180 26 188 36 224 23 222 14 178 16 167 0
Line -16777216 false 225 90 270 90
Line -16777216 false 225 15 225 90
Line -16777216 false 270 15 270 90
Line -16777216 false 247 15 247 90
Rectangle -6459832 true false 240 90 255 300

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
