;; bugs and birds are both breeds of turtle.
breed [bugs bug]  ;; bugs is its own plural, so we use "bug" as the singular.
breed [birds bird]
;; both birds and bugs have energy
turtles-own [ energy]
patches-own [grass-spot? countdown]
globals [stride-length bird-reproduce bugs-reproduce
   min-energy-of-any-bug 
   max-energy-of-any-bug 
   avg-energy-of-bugs 
   rock-color
   dirt-color
   grass-color
  ]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Setup procedures ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup
  ca
  reset-ticks
  
  set stride-length .2
  set bird-reproduce 4
  set bugs-reproduce 5
  set grass-color green
  set dirt-color brown - 1
  set rock-color gray + 4
  
  clear-output
  setup-grass
  
  set-default-shape bugs "bug"
  create-bugs initial-number-bugs  ;; create the bugs, then initialize their variables
  [
    set color blue - 2
    set size 1.5  ;; easier to see
    set label-color yellow + 2.5
    set energy random (4 * bugs-gain-from-food)  
    setxy random-xcor random-ycor
  ]
  set-default-shape birds "bird"
  create-birds initial-number-birds  ;; create the birds, then initialize their variables
  [
    set color red - 1
    set size 1.5  ;; easier to see
    set label-color yellow + 2.5
    set energy random (2 * bird-gain-from-food)  
    setxy random-xcor random-ycor
  ]
  
  
  display-labels
  update-plots
end

to setup-grass
  ask patches [set grass-spot? false set pcolor rock-color]
  ask n-of (floor (count patches * %-grass / 100)) patches [ set grass-spot? true ]
  ;; check GRASS? switch.
  ;; if it is true, then grass grows and the bugs eat it
  ;; if it false, then the bugs don't need to eat
    ask patches [
     if grass-spot? [
        ifelse random 2 = 0 
          [set pcolor grass-color]
          [set pcolor dirt-color set countdown random grass-regrowth-time ];; initialize grass grow clocks randomly
       ]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Runtime procedures ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
  if not any? turtles  [ stop ]
 
    
  ask bugs [
    if moving-lose-energy? [
      set energy energy - 1  ;; deduct energy for bugs only if grass? switch is on
    ]
      wander
      eat-grass
      death
   if reproduce? [ reproduce-bugs ]
    
  ]
  
  ask birds [
    if moving-lose-energy? [
      set energy energy - 1  ;; deduct energy for bugs only if grass? switch is on
    ]
    fd stride-length
    catch-bugs
    death
    if reproduce? [ reproduce-birds ]
    
  ]
  every 0.1
  [
    
    display
  ]
  
   ask patches [ grow-grass ]
  tick
  update-plots
  display-labels
end
to wander  ;; turtle procedure
  rt random 50
  lt random 50
  fd stride-length
end



to eat-grass  ;; bugs procedure
  ;; bugs eat grass, turn the patch brown
  if pcolor = green [
    set pcolor dirt-color
    set energy energy + bugs-gain-from-food  ;; bugs gain energy by eating
  ]
end
to reproduce-bugs  ;; bugs procedure
  if random-float 100 < bugs-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)                ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd stride-length ]   ;; hatch an offspring and move it forward 1 step
  ]
end
to reproduce-birds  ;; bird procedure
  if random-float 100 < bird-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)               ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd stride-length ]  ;; hatch an offspring and move it forward 1 step
  ]
end
to catch-bugs  ;; bird procedure
  let prey one-of bugs-here                    ;; grab a random bugs
  if prey != nobody                             ;; did we get one?  if so,
    [ ask prey [ die ]                          ;; kill it
      set energy energy + bird-gain-from-food ] ;; get energy from eating
end
to death  ;; turtle procedure
  ;; when energy dips below zero, die
  if energy < 0 [ die ]
end
to grow-grass  ;; patch procedure
  ;; countdown on brown patches: if reach 0, grow some grass
  if pcolor = dirt-color  [
    ifelse countdown <= 0
      [ set pcolor grass-color
        set countdown grass-regrowth-time ]
      [ set countdown countdown - 1 ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Plotting Procedures  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to update-plots
  set-current-plot "populations"
  set-current-plot-pen "bugs"
  plot count bugs
  set-current-plot-pen "birds"
  plot count birds
  
    set-current-plot-pen "grass / 4"
    plot count patches with [pcolor = green] / 4  ;; divide by four to keep it within similar
                                                  ;; range as bird and bugs populations
  
  
  
end
to display-labels
  ask turtles [ set label "" ]
  if show-energy? [
    ask birds [ set label round energy ]
    if show-energy? [ ask bugs [ set label round energy set label-color red + 3.5 ] ]
  ]
end


to update-statistics
   set min-energy-of-any-bug min [energy] of bugs
   set max-energy-of-any-bug max [energy] of bugs
   set avg-energy-of-bugs mean [energy] of bugs
end
  
;;to drop-turtle [name coords]
;;  ask turtles with [grabber = name] 
;;  [ setxy first coords last coords
;;    set grabber "" ]
;;end


@#$#@#$#@
GRAPHICS-WINDOW
361
10
812
482
24
24
9.0
1
8
1
1
1
0
1
1
1
-24
24
-24
24
1
1
1
ticks
CC-WINDOW
5
564
821
659
Command Center
0
SLIDER
8
209
172
242
initial-number-bugs
initial-number-bugs
0
250
102
1
1
NIL
HORIZONTAL
SLIDER
6
242
171
275
bugs-gain-from-food
bugs-gain-from-food
0.0
50.0
20
1.0
1
NIL
HORIZONTAL
SLIDER
187
207
357
240
initial-number-birds
initial-number-birds
0
250
103
1
1
NIL
HORIZONTAL
SLIDER
188
243
357
276
bird-gain-from-food
bird-gain-from-food
0.0
100.0
40
1.0
1
NIL
HORIZONTAL
SLIDER
125
90
337
123
grass-regrowth-time
grass-regrowth-time
0
100
75
1
1
NIL
HORIZONTAL
BUTTON
8
28
77
61
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
80
28
147
61
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
PLOT
7
430
356
550
populations
time
pop.
0.0
100.0
0.0
100.0
true
true
PENS
"bugs" 1.0 0 -13345367 true
"birds" 1.0 0 -2674135 true
"grass / 4" 1.0 0 -10899396 true
MONITOR
49
378
120
423
bugs
count bugs
3
1
11
MONITOR
124
378
206
423
birds
count birds
3
1
11
MONITOR
210
378
286
423
grass / 4
count patches with [ pcolor = green ] / 4
0
1
11
TEXTBOX
13
136
153
155
Bug settings
11
0.0
0
TEXTBOX
191
136
304
154
Bird settings
11
0.0
0
TEXTBOX
16
69
168
87
Grass settings
11
0.0
0
SWITCH
157
28
293
61
show-energy?
show-energy?
0
1
-1000
SLIDER
12
90
125
123
%-grass
%-grass
0
100
80
5
1
%
HORIZONTAL
BUTTON
529
492
684
525
remove half of bugs
ask  n-of (floor (.5 * (count bugs))) bugs [die]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
SWITCH
82
300
270
333
moving-lose-energy?
moving-lose-energy?
0
1
-1000
SWITCH
81
333
271
366
reproduce?
reproduce?
0
1
-1000
MONITOR
298
26
355
71
NIL
ticks
0
1
11
CHOOSER
8
163
148
208
bug-food-source
bug-food-source
"bugs eat grass" "bugs eat bugs" "bugs eat birds"
0
CHOOSER
187
161
328
206
bird-food-source
bird-food-source
"birds eat grass" "birds eat bugs" "birds eat birds"
0
TEXTBOX
117
285
267
303
Bug and Bird settings
11
0.0
1
@#$#@#$#@
VERSION
-------
$Id: BugHunt Predation.nlogo 40958 2008-09-04 21:50:13Z tisue $

WHAT IS IT?
-----------
This model explores the stability of predator-prey ecosystems. Such a system is called unstable if it tends to result in extinction for one or more species involved.  In contrast, a system is stable if it tends to maintain itself over time, despite fluctuations in population sizes.

HOW IT WORKS
------------
There are two main variations to this model.
In the first variation, wolves and sheep wander randomly around the landscape, while the wolves look for sheep to prey on. Each step costs the wolves energy, and they must eat sheep in order to replenish their energy - when they run out of energy they die. To allow the population to continue, each wolf or sheep has a fixed probability of reproducing at each time step. This variation produces interesting population dynamics, but is ultimately unstable.
The second variation includes grass (green) in addition to wolves and sheep. The behavior of the wolves is identical to the first variation, however this time the sheep must eat grass in order to maintain their energy - when they run out of energy they die. Once grass is eaten it will only regrow after a fixed amount of time. This variation is more complex than the first, but it is generally stable.
The construction of this model is described in two papers by Wilensky & Reisman referenced below.

HOW TO USE IT
-------------
1. Set the GRASS? switch to TRUE to include grass in the model, or to FALSE to only include wolves (red) and sheep (white).
2. Adjust the slider parameters (see below), or use the default settings.
3. Press the SETUP button.
4. Press the GO button to begin the simulation.
5. Look at the monitors to see the current population sizes
6. Look at the POPULATIONS plot to watch the populations fluctuate over time
Parameters:
INITIAL-NUMBER-SHEEP: The initial size of sheep population
INITIAL-NUMBER-WOLVES: The initial size of wolf population
SHEEP-GAIN-FROM-FOOD: The amount of energy sheep get for every grass patch eaten
WOLF-GAIN-FROM-FOOD: The amount of energy wolves get for every sheep eaten
SHEEP-REPRODUCE: The probability of a sheep reproducing at each time step
WOLF-REPRODUCE: The probability of a wolf reproducing at each time step
GRASS?: Whether or not to include grass in the model
GRASS-REGROWTH-TIME: How long it takes for grass to regrow once it is eaten
SHOW-ENERGY?: Whether or not to show the energy of each animal as a number
Notes:
- one unit of energy is deducted for every step a wolf takes
- when grass is included, one unit of energy is deducted for every step a sheep takes

THINGS TO NOTICE
----------------
When grass is not included, watch as the sheep and wolf populations fluctuate. Notice that increases and decreases in the sizes of each population are related. In what way are they related? What eventually happens?
Once grass is added, notice the green line added to the population plot representing fluctuations in the amount of grass. How do the sizes of the three populations appear to relate now? What is the explanation for this?
Why do you suppose that some variations of the model might be stable while others are not?

THINGS TO TRY
-------------
Try adjusting the parameters under various settings. How sensitive is the stability of the model to the particular parameters?
Can you find any parameters that generate a stable ecosystem that includes only wolves and sheep?
Try setting GRASS? to TRUE, but setting INITIAL-NUMBER-WOLVES to 0. This gives a stable ecosystem with only sheep and grass. Why might this be stable while the variation with only sheep and wolves is not?
Notice that under stable settings, the populations tend to fluctuate at a predictable pace. Can you find any parameters that will speed this up or slow it down?
Try changing the reproduction rules -- for example, what would happen if reproduction depended on energy rather than being determined by a fixed probability?

EXTENDING THE MODEL
-------------------
There are a number ways to alter the model so that it will be stable with only wolves and sheep (no grass). Some will require new elements to be coded in or existing behaviors to be changed. Can you develop such a version?

NETLOGO FEATURES
----------------
Note the use of breeds to model two different kinds of "turtles": wolves and sheep. Note the use of patches to model grass.
Note use of the ONE-OF agentset reporter to select a random sheep to be eaten by a wolf.

RELATED MODELS
---------------
Look at Rabbits Grass Weeds for another model of interacting populations with different rules.

CREDITS AND REFERENCES
----------------------
Wilensky, U. & Reisman, K. (1999). Connected Science: Learning Biology through Constructing and Testing Computational Theories -- an Embodied Modeling Approach. International Journal of Complex Systems, M. 234, pp. 1 - 12. (This model is a slightly extended version of the model described in the paper.)
Wilensky, U. & Reisman, K. (in press). Thinking like a Wolf, a Sheep or a Firefly: Learning Biology through Constructing and Testing Computational Theories -- an Embodied Modeling Approach. Cognition & Instruction.
To refer to this model in academic publications, please use:  Wilensky, U. (1997).  NetLogo Wolf Sheep Predation model.  http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
In other publications, please use:  Copyright 1997 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
bird
true
0
Polygon -7500403 true true 151 170 136 170 123 229 143 244 156 244 179 229 166 170
Polygon -16777216 true false 152 154 137 154 125 213 140 229 159 229 179 214 167 154
Polygon -7500403 true true 151 140 136 140 126 202 139 214 159 214 176 200 166 140
Polygon -16777216 true false 151 125 134 124 128 188 140 198 161 197 174 188 166 125
Polygon -7500403 true true 152 86 227 72 286 97 272 101 294 117 276 118 287 131 270 131 278 141 264 138 267 145 228 150 153 147
Polygon -7500403 true true 160 74 159 61 149 54 130 53 139 62 133 81 127 113 129 149 134 177 150 206 168 179 172 147 169 111
Circle -16777216 true false 144 55 7
Polygon -16777216 true false 129 53 135 58 139 54
Polygon -7500403 true true 148 86 73 72 14 97 28 101 6 117 24 118 13 131 30 131 22 141 36 138 33 145 72 150 147 147
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 80 91 140
Circle -7500403 true true 110 45 80
Line -7500403 true 150 85 80 15
Line -7500403 true 150 85 220 15
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
sheep
false
0
Rectangle -16777216 true false 166 225 195 285
Rectangle -16777216 true false 62 225 90 285
Rectangle -7500403 true true 30 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 180 76 116
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
wolf
false
0
Rectangle -7500403 true true 195 106 285 150
Rectangle -7500403 true true 195 90 255 105
Polygon -7500403 true true 240 90 217 44 196 90
Polygon -16777216 true false 234 89 218 59 203 89
Rectangle -1 true false 240 93 252 105
Rectangle -16777216 true false 242 96 249 104
Rectangle -16777216 true false 241 125 285 139
Polygon -1 true false 285 125 277 138 269 125
Polygon -1 true false 269 140 262 125 256 140
Rectangle -7500403 true true 45 120 195 195
Rectangle -7500403 true true 45 114 185 120
Rectangle -7500403 true true 165 195 180 270
Rectangle -7500403 true true 60 195 75 270
Polygon -7500403 true true 45 105 15 30 15 75 45 150 60 120
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1pre4
@#$#@#$#@
setup
set grass? true
repeat 75 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
BUTTON
68
13
131
46
up
NIL
NIL
1
T
OBSERVER
NIL
NIL
BUTTON
117
50
180
83
right
NIL
NIL
1
T
OBSERVER
NIL
NIL
BUTTON
19
49
82
82
left
NIL
NIL
1
T
OBSERVER
NIL
NIL
BUTTON
66
84
131
117
down
NIL
NIL
1
T
OBSERVER
NIL
NIL
CHOOSER
239
31
385
76
my-view
my-view
"whole world" "spotlight on me" "ride and follow"
0
VIEW
413
25
813
425
0
0
0
1
1
1
1
1
0
1
1
1
-24
24
-24
24
MONITOR
185
135
317
184
Energy of your bug
NIL
1
1
MONITOR
2
187
141
236
Min Energy Any Bug
NIL
1
1
MONITOR
268
187
410
236
Max Energy Any Bug
NIL
1
1
MONITOR
130
187
266
236
Avg Energy of Bugs
NIL
1
1
MONITOR
56
135
183
184
Your name
NIL
3
1
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
